/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.module;

import io.activej.common.Checks;
import io.activej.inject.Key;
import io.activej.inject.KeyPattern;
import io.activej.inject.Scope;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingGenerator;
import io.activej.inject.binding.BindingTransformer;
import io.activej.inject.binding.Multibinder;
import io.activej.inject.module.Module;
import io.activej.inject.module.ModuleBuilder;
import io.activej.inject.module.ModuleBuilder0;
import io.activej.inject.module.ModuleBuilderImpl;
import io.activej.inject.util.ReflectionUtils;
import io.activej.inject.util.Trie;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModule
implements Module {
    private Trie<Scope, Map<Key<?>, Set<Binding<?>>>> bindings;
    private Map<KeyPattern<?>, Set<BindingGenerator<?>>> bindingGenerators;
    private Map<KeyPattern<?>, Set<BindingTransformer<?>>> bindingTransformers;
    private Map<Key<?>, Multibinder<?>> multibinders;
    @Nullable
    private ModuleBuilder builder;
    @Nullable
    private final StackWalker.StackFrame location;

    protected AbstractModule() {
        Class<?> cls = this.getClass();
        this.location = StackWalker.getInstance().walk(frames -> frames.skip(1L).filter(stackFrame -> {
            try {
                String className = stackFrame.getClassName();
                Class<?> traceCls = Class.forName(className);
                if (!(traceCls.isAssignableFrom(cls) || className.startsWith("sun.reflect") || className.startsWith("java.lang"))) {
                    return true;
                }
            }
            catch (ClassNotFoundException ignored) {
                return false;
            }
            return false;
        }).findFirst().orElse(null));
        this.builder = new ModuleBuilderImpl(this.getName(), this.location);
    }

    protected void configure() {
    }

    protected final <T> ModuleBuilder0<T> bind(Key<T> key) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        return this.builder.bind(key);
    }

    protected final <T> ModuleBuilder0<T> bind(Class<T> type) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        return this.builder.bind(type);
    }

    protected final <T> ModuleBuilder0<T> bind(Class<T> type, Object qualifier) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        return this.builder.bind(type, qualifier);
    }

    protected final <T> void bindInstanceProvider(Class<T> key) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        this.builder.bindInstanceProvider(key);
    }

    protected final <T> void bindInstanceProvider(Key<T> key) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        this.builder.bindInstanceProvider(key);
    }

    protected final <T> void bindInstanceInjector(Class<T> key) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        this.builder.bindInstanceInjector(key);
    }

    protected final <T> void bindInstanceInjector(Key<T> key) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        this.builder.bindInstanceInjector(key);
    }

    protected final <T> void bindOptionalDependency(Class<T> key) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        this.builder.bindOptionalDependency(key);
    }

    protected final <T> void bindOptionalDependency(Key<T> key) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        this.builder.bindOptionalDependency(key);
    }

    protected final void install(Module module) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot install modules before or after configure() call");
        this.builder.install(module);
    }

    protected final <T> void generate(KeyPattern<T> pattern, BindingGenerator<T> bindingGenerator) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add generators before or after configure() call");
        this.builder.generate(pattern, bindingGenerator);
    }

    protected final <T> void generate(Class<T> pattern, BindingGenerator<T> bindingGenerator) {
        this.generate(KeyPattern.of(pattern), bindingGenerator);
    }

    protected final <T> void transform(KeyPattern<T> pattern, BindingTransformer<T> bindingTransformer) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add transformers before or after configure() call");
        this.builder.transform(pattern, bindingTransformer);
    }

    protected final <T> void transform(Class<T> pattern, BindingTransformer<T> bindingTransformer) {
        this.transform(KeyPattern.of(pattern), bindingTransformer);
    }

    protected final <T> void multibind(Key<T> key, Multibinder<T> multibinder) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add multibinders before or after configure() call");
        this.builder.multibind(key, multibinder);
    }

    protected final <V> void multibindToSet(Class<V> type) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        this.builder.multibindToSet(type);
    }

    protected final <V> void multibindToSet(Class<V> type, Object qualifier) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        this.builder.multibindToSet(type, qualifier);
    }

    protected final <V> void multibindToSet(Key<V> key) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        this.builder.multibindToSet(key);
    }

    protected final <K, V> void multibindToMap(Class<K> keyType, Class<V> valueType) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        this.builder.multibindToMap(keyType, valueType);
    }

    protected final <K, V> void multibindToMap(Class<K> keyType, Class<V> valueType, Object qualifier) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add bindings before or after configure() call");
        this.builder.multibindToMap(keyType, valueType, qualifier);
    }

    protected final <S, T extends S> void bindIntoSet(Key<S> setOf, Binding<T> binding) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot bind into set before or after configure() call");
        this.builder.bindIntoSet(setOf, binding);
    }

    protected final <S, T extends S> void bindIntoSet(Key<S> setOf, Key<T> item) {
        this.bindIntoSet(setOf, (T)Binding.to(item));
    }

    protected final <S, T extends S> void bindIntoSet(Key<S> setOf, T element) {
        this.bindIntoSet(setOf, (T)Binding.toInstance(element));
    }

    protected final void scan(Object object) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add declarative bindings before or after configure() call");
        this.builder.scan(object);
    }

    protected final void scan(Class<?> cls) {
        Checks.checkState((this.builder != null ? 1 : 0) != 0, (Object)"Cannot add declarative bindings before or after configure() call");
        this.builder.scan(cls);
    }

    private void finish() {
        if (this.builder == null) {
            return;
        }
        this.builder.scan(this.getClass().getSuperclass(), this);
        ReflectionUtils.scanClassInto(this.getClass(), this, this.builder);
        this.configure();
        Module module = this.builder.build();
        this.builder = null;
        this.bindings = module.getBindings();
        this.bindingTransformers = module.getBindingTransformers();
        this.bindingGenerators = module.getBindingGenerators();
        this.multibinders = module.getMultibinders();
    }

    @Override
    public final Trie<Scope, Map<Key<?>, Set<Binding<?>>>> getBindings() {
        this.finish();
        return this.bindings;
    }

    @Override
    public final Map<KeyPattern<?>, Set<BindingTransformer<?>>> getBindingTransformers() {
        this.finish();
        return this.bindingTransformers;
    }

    @Override
    public final Map<KeyPattern<?>, Set<BindingGenerator<?>>> getBindingGenerators() {
        this.finish();
        return this.bindingGenerators;
    }

    @Override
    public final Map<Key<?>, Multibinder<?>> getMultibinders() {
        this.finish();
        return this.multibinders;
    }

    @Override
    public Module combineWith(Module another) {
        return Module.super.combineWith(another);
    }

    @Override
    public Module overrideWith(Module another) {
        return Module.super.overrideWith(another);
    }

    @Override
    public Module transformWith(UnaryOperator<Module> fn) {
        return Module.super.transformWith(fn);
    }

    private String getName() {
        Class<?> cls = this.getClass();
        return ReflectionUtils.getDisplayName(cls.isAnonymousClass() ? cls.getGenericSuperclass() : cls);
    }

    public String toString() {
        return this.getName() + "(at " + (this.location != null ? this.location : "<unknown module location>") + ")";
    }
}

