/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.impl;

import io.activej.common.collection.CollectionUtils;
import io.activej.inject.InstanceInjector;
import io.activej.inject.InstanceProvider;
import io.activej.inject.Key;
import io.activej.inject.Scope;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingGenerator;
import io.activej.inject.binding.BindingTransformer;
import io.activej.inject.binding.BindingType;
import io.activej.inject.binding.DIException;
import io.activej.inject.binding.Multibinder;
import io.activej.inject.binding.OptionalDependency;
import io.activej.inject.impl.AbstractCompiledBinding;
import io.activej.inject.impl.BindingInitializer;
import io.activej.inject.impl.BindingLocator;
import io.activej.inject.impl.BindingSynthesizer;
import io.activej.inject.impl.CompiledBinding;
import io.activej.inject.impl.CompiledBindingInitializer;
import io.activej.inject.impl.CompiledBindingLocator;
import io.activej.inject.module.UniqueQualifierImpl;
import io.activej.inject.util.ReflectionUtils;
import io.activej.inject.util.Trie;
import io.activej.inject.util.Utils;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class Preprocessor {
    private static final List<MissingKeyHint> missingKeyHints = List.of((missing, upperKnown, bindings) -> {
        if (missing.getRawType() != InstanceProvider.class) {
            return null;
        }
        return "it was not generated because there were no *exported* binding for key " + missing.getTypeParameter(0).getDisplayString();
    });
    private static final List<ErrorHint> errorHints = List.of((keybind, missing, upperKnown, bindings) -> {
        Class rawType = ((Key)keybind.getKey()).getRawType();
        if (Modifier.isStatic(rawType.getModifiers()) || !missing.getRawType().equals(rawType.getEnclosingClass())) {
            return null;
        }
        return "this is a non-static inner class with implicit dependency on its enclosing class";
    }, (keybind, missing, upperKnown, bindings) -> {
        if (((Key)keybind.getKey()).getRawType() != InstanceInjector.class) {
            return null;
        }
        Object missingQualifier = missing.getQualifier();
        Type missingType = missing.getType();
        Key priv = Stream.concat(((Map)bindings.get()).keySet().stream(), upperKnown.stream()).filter(k -> k.getQualifier() instanceof UniqueQualifierImpl && k.getType().equals(missingType) && Objects.equals(missingQualifier, ((UniqueQualifierImpl)k.getQualifier()).getOriginalQualifier())).findAny().orElse(null);
        if (priv == null) {
            return null;
        }
        return "instance injectors cannot inject private keys (found private key " + priv.getDisplayString() + " " + Utils.getLocation((Binding)((Map)bindings.get()).get(priv)) + ")";
    });

    private Preprocessor() {
    }

    public static Trie<Scope, Map<Key<?>, Binding<?>>> reduce(Trie<Scope, Map<Key<?>, Set<Binding<?>>>> bindings, Multibinder<?> multibinder, BindingTransformer<?> transformer, BindingGenerator<?> generator) {
        Trie<Scope, Map<Key<?>, Binding<?>>> reduced = Trie.leaf(new HashMap());
        BindingSynthesizer synthesizer = new BindingSynthesizer();
        Preprocessor.reduce(Scope.UNSCOPED, Map.of(), bindings, reduced, multibinder, transformer, generator, synthesizer);
        synthesizer.synthesizeMissing(reduced);
        return reduced;
    }

    private static void reduce(Scope[] scope, Map<Key<?>, Binding<?>> upper, Trie<Scope, Map<Key<?>, Set<Binding<?>>>> bindings, Trie<Scope, Map<Key<?>, Binding<?>>> reduced, Multibinder<?> multibinder, BindingTransformer<?> transformer, BindingGenerator<?> generator, BindingSynthesizer synthesizer) {
        Map<Key<?>, Set<Binding<?>>> localBindings = bindings.get();
        localBindings.forEach((key, bindingSet) -> {
            Binding<?> resolved = Preprocessor.resolve(upper, localBindings, (Map)reduced.get(), scope, key, bindingSet, multibinder, transformer, generator, synthesizer);
            if (resolved == null) {
                synthesizer.addMissing(scope, (Key<?>)key, false);
            }
        });
        Map<Key<?>, Binding<?>> nextUpper = Utils.override(upper, reduced.get());
        bindings.getChildren().forEach((subScope, subLocalBindings) -> Preprocessor.reduce(Utils.next(scope, subScope), nextUpper, subLocalBindings, reduced.computeIfAbsent((Scope)subScope, $ -> new HashMap()), multibinder, transformer, generator, synthesizer));
    }

    @Nullable
    private static Binding<?> resolve(final Map<Key<?>, Binding<?>> upper, final Map<Key<?>, Set<Binding<?>>> localBindings, final Map<Key<?>, Binding<?>> resolvedBindings, final Scope[] scope, Key<?> key, @Nullable Set<Binding<?>> bindingSet, final Multibinder<?> multibinder, final BindingTransformer<?> transformer, final BindingGenerator<?> generator, final BindingSynthesizer synthesizer) {
        Binding<?> binding;
        BindingLocator recursiveLocator;
        block10: {
            Class<?> rawType;
            block9: {
                Binding<?> resolvedBinding = resolvedBindings.get(key);
                if (resolvedBinding != null) {
                    return resolvedBinding;
                }
                recursiveLocator = new BindingLocator(){

                    @Override
                    @Nullable
                    public <T> Binding<T> get(Key<T> key) {
                        return Preprocessor.resolve(upper, localBindings, resolvedBindings, scope, key, (Set)localBindings.get(key), multibinder, transformer, generator, synthesizer);
                    }
                };
                rawType = key.getRawType();
                if (bindingSet == null) break block9;
                switch (bindingSet.size()) {
                    case 0: {
                        binding = Preprocessor.tryResolve(upper, localBindings, resolvedBindings, scope, key, multibinder, transformer, generator, recursiveLocator, rawType, synthesizer);
                        if (binding == null) {
                            synthesizer.addMissing(scope, key, true);
                            return null;
                        }
                        break block10;
                    }
                    case 1: {
                        binding = bindingSet.iterator().next();
                        break;
                    }
                    default: {
                        binding = multibinder.multibind(key, bindingSet);
                        break;
                    }
                }
                break block10;
            }
            Binding<?> fromUpper = upper.get(key);
            if (fromUpper != null) {
                return fromUpper;
            }
            binding = Preprocessor.tryResolve(upper, localBindings, resolvedBindings, scope, key, multibinder, transformer, generator, recursiveLocator, rawType, synthesizer);
            if (binding == null) {
                return null;
            }
        }
        Binding<?> transformed = transformer.transform(recursiveLocator, scope, key, binding);
        resolvedBindings.put(key, transformed);
        for (Key<?> d : transformed.getDependencies()) {
            Binding<?> resolved = Preprocessor.resolve(upper, localBindings, resolvedBindings, scope, d, localBindings.get(d), multibinder, transformer, generator, synthesizer);
            if (resolved != null) continue;
            synthesizer.addMissing(scope, d, false);
        }
        return transformed;
    }

    @Nullable
    private static Binding<?> tryResolve(Map<Key<?>, Binding<?>> upper, Map<Key<?>, Set<Binding<?>>> localBindings, Map<Key<?>, Binding<?>> resolvedBindings, Scope[] scope, Key<?> key, Multibinder<?> multibinder, BindingTransformer<?> transformer, BindingGenerator<?> generator, BindingLocator recursiveLocator, Class<?> rawType, BindingSynthesizer synthesizer) {
        Binding<Object> binding = generator.generate(recursiveLocator, scope, key);
        if (binding == null && rawType == OptionalDependency.class) {
            binding = Preprocessor.resolveOptionalDependency(upper, localBindings, resolvedBindings, scope, key, multibinder, transformer, generator, synthesizer);
        }
        if (binding == null && rawType == InstanceProvider.class) {
            binding = Preprocessor.resolveInstanceProvider(upper, localBindings, resolvedBindings, scope, key, multibinder, transformer, generator, synthesizer);
        }
        if (binding == null && rawType == InstanceInjector.class) {
            binding = Preprocessor.resolveInstanceInjector(key);
        }
        if (binding == null && rawType == Key.class) {
            binding = Binding.toInstance(key.getTypeParameter(0)).as(BindingType.SYNTHETIC);
        }
        if (binding == null) {
            binding = ReflectionUtils.generateImplicitBinding(key);
        }
        return binding;
    }

    private static Binding<?> resolveOptionalDependency(Map<Key<?>, Binding<?>> upper, Map<Key<?>, Set<Binding<?>>> localBindings, Map<Key<?>, Binding<?>> resolvedBindings, Scope[] scope, Key<?> key, Multibinder<?> multibinder, BindingTransformer<?> transformer, BindingGenerator<?> generator, BindingSynthesizer synthesizer) {
        Key instanceKey = key.getTypeParameter(0).qualified(key.getQualifier());
        if (instanceKey.getRawType() == OptionalDependency.class) {
            throw new DIException("Nested optional dependencies are not allowed");
        }
        Binding<?> resolved = Preprocessor.resolve(upper, localBindings, resolvedBindings, scope, instanceKey, localBindings.get(instanceKey), multibinder, transformer, generator, synthesizer);
        if (resolved != null) {
            return BindingSynthesizer.optinalDependencyBinding(instanceKey);
        }
        synthesizer.addMissing(scope, key, false);
        return null;
    }

    @Nullable
    private static Binding<?> resolveInstanceProvider(Map<Key<?>, Binding<?>> upper, Map<Key<?>, Set<Binding<?>>> localBindings, Map<Key<?>, Binding<?>> resolvedBindings, Scope[] scope, Key<?> key, Multibinder<?> multibinder, BindingTransformer<?> transformer, BindingGenerator<?> generator, BindingSynthesizer synthesizer) {
        Key<Object> instanceKey = key.getTypeParameter(0).qualified(key.getQualifier());
        Binding<?> resolved = Preprocessor.resolve(upper, localBindings, resolvedBindings, scope, instanceKey, localBindings.get(instanceKey), multibinder, transformer, generator, synthesizer);
        if (resolved != null) {
            return BindingSynthesizer.instanceProviderBinding(instanceKey);
        }
        synthesizer.addMissing(scope, key, false);
        return null;
    }

    private static Binding<?> resolveInstanceInjector(Key<?> key) {
        final Key instanceKey = key.getTypeParameter(0).qualified(key.getQualifier());
        final BindingInitializer bindingInitializer = ReflectionUtils.generateInjectingInitializer(instanceKey);
        return new Binding<InstanceInjector<?>>(bindingInitializer.getDependencies(), BindingType.SYNTHETIC, null){

            @Override
            public CompiledBinding<InstanceInjector<?>> compile(final CompiledBindingLocator compiledBindings, boolean threadsafe, int synchronizedScope, @Nullable Integer slot) {
                return slot != null ? new AbstractCompiledBinding<InstanceInjector<?>>(synchronizedScope, slot){

                    @Override
                    protected InstanceInjector<?> doCreateInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        CompiledBindingInitializer compiledBindingInitializer = bindingInitializer.compile(compiledBindings);
                        return new InstanceInjectorImpl(instanceKey, compiledBindingInitializer, scopedInstances, synchronizedScope);
                    }
                } : new CompiledBinding<InstanceInjector<?>>(){

                    @Override
                    public InstanceInjector<?> getInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        CompiledBindingInitializer compiledBindingInitializer = bindingInitializer.compile(compiledBindings);
                        return new InstanceInjectorImpl(instanceKey, compiledBindingInitializer, scopedInstances, synchronizedScope);
                    }
                };
            }
        };
    }

    public static void check(Set<Key<?>> known, Trie<Scope, Map<Key<?>, Binding<?>>> bindings) {
        Preprocessor.checkUnsatisfied(Scope.UNSCOPED, known, bindings);
        Preprocessor.checkCycles(Scope.UNSCOPED, bindings);
    }

    private static void checkUnsatisfied(Scope[] scope, Set<Key<?>> upperKnown, Trie<Scope, Map<Key<?>, Binding<?>>> bindings) {
        class DependencyToBinding {
            final Key<?> dependency;
            final Map.Entry<Key<?>, Binding<?>> keybinding;

            public DependencyToBinding(Key<?> dependency, Map.Entry<Key<?>, Binding<?>> keybinding) {
                this.dependency = dependency;
                this.keybinding = keybinding;
            }
        }
        Set known = CollectionUtils.union(upperKnown, bindings.get().keySet());
        Map<Key, Set<Map.Entry>> unsatisfied = bindings.get().entrySet().stream().flatMap(e -> ((Binding)e.getValue()).getDependencies().stream().filter(dependency -> !known.contains(dependency)).map(dependency -> new DependencyToBinding((Key<?>)dependency, (Map.Entry<Key<?>, Binding<?>>)e))).collect(Utils.toMultimap(dtb -> dtb.dependency, dtb -> dtb.keybinding));
        if (!unsatisfied.isEmpty()) {
            throw new DIException(unsatisfied.entrySet().stream().map(entry -> {
                Key missing = (Key)entry.getKey();
                String header = "\tkey " + missing.getDisplayString() + " required to make:\n";
                List mkhs = missingKeyHints.stream().map(it -> it.getHintFor(missing, upperKnown, bindings)).filter(Objects::nonNull).collect(Collectors.toList());
                if (!mkhs.isEmpty()) {
                    String prefix = "\t" + new String(new char[Utils.getKeyDisplayCenter(missing) + 4]).replace('\u0000', ' ') + "^- ";
                    header = header + prefix + String.join((CharSequence)("\n" + prefix), mkhs) + "\n";
                }
                return ((Set)entry.getValue()).stream().map(keybind -> {
                    Key key = (Key)keybind.getKey();
                    String missingDesc = key.getDisplayString() + " " + Utils.getLocation((Binding)keybind.getValue());
                    List ehs = errorHints.stream().map(it -> it.getHintFor((Map.Entry<Key<?>, Binding<?>>)keybind, missing, upperKnown, bindings)).filter(Objects::nonNull).collect(Collectors.toList());
                    if (!ehs.isEmpty()) {
                        String prefix = "\n\t\t" + new String(new char[Utils.getKeyDisplayCenter(key) + 2]).replace('\u0000', ' ') + "^- ";
                        missingDesc = missingDesc + prefix + String.join((CharSequence)prefix, ehs);
                    }
                    return missingDesc;
                }).collect(Collectors.joining("\n\t\t- ", header + "\t\t- ", ""));
            }).collect(Collectors.joining("\n", "Unsatisfied dependencies detected" + (String)(scope.length != 0 ? " in scope " + Utils.getScopeDisplayString(scope) : "") + ":\n", "\n")));
        }
        bindings.getChildren().forEach((subScope, subBindings) -> Preprocessor.checkUnsatisfied(Utils.next(scope, subScope), known, subBindings));
    }

    private static void checkCycles(Scope[] scope, Trie<Scope, Map<Key<?>, Binding<?>>> bindings) {
        List<Key<?>[]> cycles = Preprocessor.collectCycles(bindings.get());
        if (!cycles.isEmpty()) {
            throw new DIException(cycles.stream().map(Utils::drawCycle).collect(Collectors.joining("\n\n", "Cyclic dependencies detected" + (String)(scope.length != 0 ? " in scope " + Utils.getScopeDisplayString(scope) : "") + ":\n\n", "\n")));
        }
        bindings.getChildren().forEach((subScope, subBindings) -> Preprocessor.checkCycles(Utils.next(scope, subScope), subBindings));
    }

    public static List<Key<?>[]> collectCycles(Map<Key<?>, Binding<?>> bindings) {
        HashSet visited = new HashSet();
        LinkedHashSet visiting = new LinkedHashSet();
        ArrayList<Key<?>[]> cycles = new ArrayList<Key<?>[]>();
        for (Key<?> key : bindings.keySet()) {
            if (visited.contains(key)) continue;
            Preprocessor.collectCycles(bindings, visited, visiting, cycles, key);
        }
        return cycles;
    }

    private static void collectCycles(Map<Key<?>, Binding<?>> bindings, Set<Key<?>> visited, LinkedHashSet<Key<?>> visiting, List<Key<?>[]> cycles, Key<?> key) {
        Binding<?> binding = bindings.get(key);
        if (binding == null) {
            visited.add(key);
            return;
        }
        if (visiting.add(key)) {
            for (Key<?> dependency : binding.getDependencies()) {
                if (visited.contains(dependency) || dependency.getRawType() == InstanceProvider.class) continue;
                Preprocessor.collectCycles(bindings, visited, visiting, cycles, dependency);
            }
            visiting.remove(key);
            visited.add(key);
            return;
        }
        Iterator backtracked = visiting.iterator();
        int skipped = 0;
        while (!((Key)backtracked.next()).equals(key)) {
            ++skipped;
        }
        Key[] cycle = new Key[visiting.size() - skipped];
        for (int i = 0; i < cycle.length - 1; ++i) {
            cycle[i] = (Key)backtracked.next();
        }
        cycle[cycle.length - 1] = key;
        cycles.add(cycle);
    }

    @FunctionalInterface
    public static interface ErrorHint {
        @Nullable
        public String getHintFor(Map.Entry<Key<?>, Binding<?>> var1, Key<?> var2, Set<Key<?>> var3, Trie<Scope, Map<Key<?>, Binding<?>>> var4);
    }

    @FunctionalInterface
    public static interface MissingKeyHint {
        @Nullable
        public String getHintFor(Key<?> var1, Set<Key<?>> var2, Trie<Scope, Map<Key<?>, Binding<?>>> var3);
    }

    public static class InstanceInjectorImpl<T>
    implements InstanceInjector<T> {
        private final Key<T> key;
        private final CompiledBindingInitializer<T> compiledBindingInitializer;
        private final AtomicReferenceArray[] scopedInstances;
        private final int synchronizedScope;

        public InstanceInjectorImpl(Key<T> key, CompiledBindingInitializer<T> compiledBindingInitializer, AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
            this.key = key;
            this.compiledBindingInitializer = compiledBindingInitializer;
            this.scopedInstances = scopedInstances;
            this.synchronizedScope = synchronizedScope;
        }

        @Override
        public Key<T> key() {
            return this.key;
        }

        @Override
        public void injectInto(T existingInstance) {
            this.compiledBindingInitializer.initInstance(existingInstance, this.scopedInstances, this.synchronizedScope);
        }

        public String toString() {
            return "InstanceInjector<" + this.key.getDisplayString() + ">";
        }
    }

    public static class InstanceProviderImpl<T>
    implements InstanceProvider<T> {
        private final Key<T> key;
        private final CompiledBinding<T> compiledBinding;
        private final AtomicReferenceArray[] scopedInstances;
        private final int synchronizedScope;

        public InstanceProviderImpl(Key<T> key, CompiledBinding<T> compiledBinding, AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
            this.key = key;
            this.compiledBinding = compiledBinding;
            this.scopedInstances = scopedInstances;
            this.synchronizedScope = synchronizedScope;
        }

        @Override
        public Key<T> key() {
            return this.key;
        }

        @Override
        public T get() {
            return this.compiledBinding.getInstance(this.scopedInstances, this.synchronizedScope);
        }

        public String toString() {
            return "InstanceProvider<" + this.key.getDisplayString() + ">";
        }
    }
}

