/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.impl;

import io.activej.common.collection.CollectionUtils;
import io.activej.inject.InstanceProvider;
import io.activej.inject.Key;
import io.activej.inject.KeyPattern;
import io.activej.inject.Scope;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingToKey;
import io.activej.inject.binding.BindingType;
import io.activej.inject.binding.DIException;
import io.activej.inject.binding.OptionalDependency;
import io.activej.inject.impl.AbstractCompiledBinding;
import io.activej.inject.impl.CompiledBinding;
import io.activej.inject.impl.CompiledBindingLocator;
import io.activej.inject.impl.Preprocessor;
import io.activej.inject.util.Trie;
import io.activej.inject.util.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BindingSynthesizer {
    private final Trie<Scope, ScopeState> scopeStateTrie = new Trie(new ScopeState(), new HashMap());

    BindingSynthesizer() {
    }

    void addMissing(Scope[] scope, Key<?> key, boolean explicit) {
        ScopeState scopeState = this.scopeStateTrie.computeIfAbsent((Scope[])scope, $ -> new ScopeState()).get();
        scopeState.missing().add(key, explicit);
    }

    void synthesizeMissing(Trie<Scope, Map<Key<?>, Binding<?>>> reduced) {
        this.synthesizeMissing(Scope.UNSCOPED, reduced);
    }

    private void synthesizeMissing(Scope[] scope, Trie<Scope, Map<Key<?>, Binding<?>>> reduced) {
        Trie<Scope, ScopeState> trie = this.scopeStateTrie.get((Scope[])scope);
        if (trie == null) {
            return;
        }
        ScopeState scopeState = trie.get();
        Scope[] currentScope = Scope.UNSCOPED;
        while (true) {
            Trie<Scope, Map<Key<?>, Binding<?>>> next = reduced.get((Scope[])currentScope);
            this.synthesizeBindings(currentScope, scopeState, next.get());
            if (currentScope.length == scope.length) break;
            currentScope = Utils.next(currentScope, scope[currentScope.length]);
        }
        BindingSynthesizer.checkSynthesized(scope, scopeState);
        trie.getChildren().forEach((childScope, childTrie) -> this.synthesizeMissing(Utils.next(scope, childScope), reduced));
        Trie<Scope, Map<Key<?>, Binding<?>>> currentScopeTrie = reduced.get((Scope[])scope);
        Map<Key<?>, Binding<?>> currentScopeBindings = currentScopeTrie.get();
        for (Map.Entry<Key<?>, Synthesized> entry : scopeState.synthesized().entrySet()) {
            Binding<?> binding = entry.getValue().binding();
            if (binding == null) continue;
            currentScopeBindings.put(entry.getKey(), binding);
        }
    }

    private void synthesizeBindings(Scope[] scope, ScopeState scopeState, Map<Key<?>, Binding<?>> localBindings) {
        Synthesized synthesized;
        for (Key<?> key : scopeState.missing.regular()) {
            synthesized = BindingSynthesizer.synthesizeBinding(scope, scopeState, localBindings, key);
            if (synthesized == null) continue;
            scopeState.synthesized.put(key, synthesized);
        }
        for (Key<?> key : scopeState.missing.instanceProviders()) {
            synthesized = BindingSynthesizer.synthesizeInstanceProvider(scope, scopeState, localBindings, key);
            if (synthesized == null) continue;
            scopeState.synthesized.put(key, synthesized);
        }
        for (Key<?> key : scopeState.missing.optionalDependencies()) {
            synthesized = BindingSynthesizer.synthesizeOptionalDependency(scope, scopeState, localBindings, key);
            scopeState.synthesized.put(key, synthesized);
        }
    }

    @Nullable
    private static Synthesized synthesizeBinding(Scope[] scope, ScopeState scopeState, Map<Key<?>, Binding<?>> localBindings, Key<?> key) {
        Synthesized synthesized = scopeState.synthesized.get(key);
        if (synthesized != null) {
            return synthesized;
        }
        KeyPattern pattern = KeyPattern.ofType(key.getType(), key.getQualifier());
        HashMap candidates = new HashMap();
        for (Map.Entry<Key<?>, Binding<?>> entry : localBindings.entrySet()) {
            Key<?> localKey = entry.getKey();
            if (key.equals(localKey) || !pattern.match(localKey)) continue;
            candidates.put(localKey, entry.getValue());
        }
        return BindingSynthesizer.tryReduceCandidates(scope, candidates);
    }

    @Nullable
    private static Synthesized tryReduceCandidates(Scope[] scope, Map<Key<?>, Binding<?>> candidates) {
        Set<Key<?>> candidateKeys = candidates.keySet();
        HashSet keysCopy = new HashSet(candidateKeys);
        for (Map.Entry<Key<?>, Binding<?>> entry : candidates.entrySet()) {
            BindingToKey bindingToKey;
            Binding<?> binding = entry.getValue();
            if (!(binding instanceof BindingToKey) || !candidateKeys.contains((bindingToKey = (BindingToKey)binding).getKey())) continue;
            keysCopy.remove(entry.getKey());
        }
        if (keysCopy.isEmpty()) {
            return null;
        }
        if (keysCopy.size() == 1) {
            return new Synthesized(Binding.to((Key)CollectionUtils.first(keysCopy)).as(BindingType.SYNTHETIC));
        }
        return new Synthesized(new SynthesizeError(scope, keysCopy));
    }

    private static void checkSynthesized(Scope[] scope, ScopeState scopeState) {
        Synthesized synthesized;
        for (Key<?> key : scopeState.missing().all()) {
            SynthesizeError error;
            synthesized = scopeState.synthesized().get(key);
            if (synthesized == null || (error = synthesized.error()) == null) continue;
            throw new DIException("Could not synthesize a binding for " + key.getDisplayString() + " in scope " + Utils.getScopeDisplayString(scope) + ". Ambiguous bindings in scope " + Utils.getScopeDisplayString(error.scope()) + ": " + error.ambiguousCandidates().stream().map(Key::getDisplayString).toList());
        }
        for (Key<?> key : scopeState.missing().explicit()) {
            synthesized = scopeState.synthesized().get(key);
            if (synthesized != null) continue;
            throw new DIException("Could not synthesize explicit binding for " + key.getDisplayString() + " in scope " + Utils.getScopeDisplayString(scope));
        }
    }

    private static Synthesized synthesizeOptionalDependency(Scope[] scope, ScopeState scopeState, Map<Key<?>, Binding<?>> localBindings, Key<?> key) {
        Key instanceKey = key.getTypeParameter(0).qualified(key.getQualifier());
        Synthesized instanceSynthesized = BindingSynthesizer.synthesizeBinding(scope, scopeState, localBindings, instanceKey);
        if (instanceSynthesized == null || instanceSynthesized.binding() == null) {
            return new Synthesized(Binding.toInstance(OptionalDependency.empty()));
        }
        scopeState.synthesized.put(instanceKey, instanceSynthesized);
        return new Synthesized(BindingSynthesizer.optinalDependencyBinding(instanceKey));
    }

    private static Synthesized synthesizeInstanceProvider(Scope[] scope, ScopeState scopeState, Map<Key<?>, Binding<?>> localBindings, Key<?> key) {
        Key<Object> instanceKey = key.getTypeParameter(0).qualified(key.getQualifier());
        Synthesized instanceSynthesized = BindingSynthesizer.synthesizeBinding(scope, scopeState, localBindings, instanceKey);
        if (instanceSynthesized == null || instanceSynthesized.binding() == null) {
            return null;
        }
        scopeState.synthesized.put(instanceKey, instanceSynthesized);
        return new Synthesized(BindingSynthesizer.instanceProviderBinding(instanceKey));
    }

    static Binding<OptionalDependency<?>> optinalDependencyBinding(final Key<?> instanceKey) {
        return new Binding<OptionalDependency<?>>(Set.of(instanceKey), BindingType.SYNTHETIC, null){

            @Override
            public CompiledBinding<OptionalDependency<?>> compile(final CompiledBindingLocator compiledBindings, boolean threadsafe, int scope, @Nullable Integer slot) {
                return slot != null ? new AbstractCompiledBinding<OptionalDependency<?>>(scope, slot){

                    @Override
                    protected OptionalDependency<?> doCreateInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        CompiledBinding compiledBinding = compiledBindings.get(instanceKey);
                        return OptionalDependency.of(compiledBinding.getInstance(scopedInstances, synchronizedScope));
                    }
                } : new CompiledBinding<OptionalDependency<?>>(){

                    @Override
                    public OptionalDependency<?> getInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        CompiledBinding compiledBinding = compiledBindings.get(instanceKey);
                        return OptionalDependency.of(compiledBinding.getInstance(scopedInstances, synchronizedScope));
                    }
                };
            }
        };
    }

    static Binding<InstanceProvider<?>> instanceProviderBinding(final Key<Object> instanceKey) {
        return new Binding<InstanceProvider<?>>(Set.of(instanceKey), BindingType.SYNTHETIC, null){

            @Override
            public CompiledBinding<InstanceProvider<?>> compile(final CompiledBindingLocator compiledBindings, boolean threadsafe, int scope, @Nullable Integer slot) {
                return slot != null ? new AbstractCompiledBinding<InstanceProvider<?>>(scope, slot){

                    @Override
                    protected InstanceProvider<?> doCreateInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        CompiledBinding compiledBinding = compiledBindings.get(instanceKey);
                        return new Preprocessor.InstanceProviderImpl(instanceKey, compiledBinding, scopedInstances, synchronizedScope);
                    }
                } : new CompiledBinding<InstanceProvider<?>>(){

                    @Override
                    public InstanceProvider<?> getInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        CompiledBinding compiledBinding = compiledBindings.get(instanceKey);
                        return new Preprocessor.InstanceProviderImpl(instanceKey, compiledBinding, scopedInstances, synchronizedScope);
                    }
                };
            }
        };
    }

    private record ScopeState(Missing missing, Map<Key<?>, Synthesized> synthesized) {
        private ScopeState() {
            this(new Missing(), new HashMap());
        }

        private record Missing(Set<Key<?>> regular, Set<Key<?>> instanceProviders, Set<Key<?>> optionalDependencies, Set<Key<?>> explicit) {
            private Missing() {
                this(new HashSet(), new HashSet(), new HashSet(), new HashSet());
            }

            void add(Key<?> key, boolean explicit) {
                Class<?> rawType = key.getRawType();
                if (rawType == InstanceProvider.class) {
                    this.instanceProviders.add(key);
                } else if (rawType == OptionalDependency.class) {
                    this.optionalDependencies.add(key);
                } else {
                    this.regular.add(key);
                }
                if (explicit) {
                    this.explicit.add(key);
                }
            }

            Iterable<Key<?>> all() {
                return new Iterable<Key<?>>(){

                    @Override
                    @NotNull
                    public Iterator<Key<?>> iterator() {
                        return Utils.multiIterator(regular.iterator(), instanceProviders.iterator(), optionalDependencies.iterator());
                    }
                };
            }
        }
    }

    private static final class Synthesized {
        private final Binding<?> binding;
        private final SynthesizeError error;

        private Synthesized(Binding<?> binding) {
            this.binding = binding;
            this.error = null;
        }

        private Synthesized(SynthesizeError error) {
            this.binding = null;
            this.error = error;
        }

        public Binding<?> binding() {
            return this.binding;
        }

        public SynthesizeError error() {
            return this.error;
        }
    }

    private record SynthesizeError(Scope[] scope, Set<Key<?>> ambiguousCandidates) {
    }
}

