/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.impl;

import io.activej.inject.Key;
import io.activej.inject.impl.CompiledBindingInitializer;
import io.activej.inject.impl.CompiledBindingLocator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;

public abstract class BindingInitializer<T> {
    private static final BindingInitializer<?> NOOP = new BindingInitializer<Object>(Set.of()){

        @Override
        public CompiledBindingInitializer<Object> compile(CompiledBindingLocator compiledBindings) {
            return new CompiledBindingInitializer<Object>(){

                @Override
                public void initInstance(Object instance, AtomicReferenceArray[] instances, int synchronizedScope) {
                }
            };
        }
    };
    private final Set<Key<?>> dependencies;

    protected BindingInitializer(Set<Key<?>> dependencies) {
        this.dependencies = dependencies;
    }

    public Set<Key<?>> getDependencies() {
        return this.dependencies;
    }

    public abstract CompiledBindingInitializer<T> compile(CompiledBindingLocator var1);

    @SafeVarargs
    public static <T> BindingInitializer<T> combine(BindingInitializer<T> ... bindingInitializers) {
        return BindingInitializer.combine(List.of(bindingInitializers));
    }

    public static <T> BindingInitializer<T> combine(final List<BindingInitializer<T>> bindingInitializers) {
        return new BindingInitializer<T>(bindingInitializers.stream().map(BindingInitializer::getDependencies).flatMap(Collection::stream).collect(Collectors.toSet())){

            @Override
            public CompiledBindingInitializer<T> compile(CompiledBindingLocator compiledBindings) {
                final CompiledBindingInitializer[] initializers = (CompiledBindingInitializer[])bindingInitializers.stream().filter(bindingInitializer -> bindingInitializer != NOOP).map(bindingInitializer -> bindingInitializer.compile(compiledBindings)).toArray(CompiledBindingInitializer[]::new);
                if (initializers.length == 0) {
                    return new CompiledBindingInitializer<T>(){

                        @Override
                        public void initInstance(T instance, AtomicReferenceArray[] instances, int synchronizedScope) {
                        }
                    };
                }
                if (initializers.length == 1) {
                    return initializers[0];
                }
                if (initializers.length == 2) {
                    final CompiledBindingInitializer initializer0 = initializers[0];
                    final CompiledBindingInitializer initializer1 = initializers[1];
                    return new CompiledBindingInitializer<T>(){

                        @Override
                        public void initInstance(T instance, AtomicReferenceArray[] instances, int synchronizedScope) {
                            initializer0.initInstance(instance, instances, synchronizedScope);
                            initializer1.initInstance(instance, instances, synchronizedScope);
                        }
                    };
                }
                return new CompiledBindingInitializer<T>(){

                    @Override
                    public void initInstance(T instance, AtomicReferenceArray[] instances, int synchronizedScope) {
                        for (int i = 0; i < initializers.length; ++i) {
                            initializers[i].initInstance(instance, instances, synchronizedScope);
                        }
                    }
                };
            }
        };
    }

    public static <T> BindingInitializer<T> noop() {
        return NOOP;
    }
}

