/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.binding;

import io.activej.inject.Key;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingType;
import io.activej.inject.binding.DIException;
import io.activej.inject.binding.Multibinder;
import io.activej.inject.impl.AbstractCompiledBinding;
import io.activej.inject.impl.CompiledBinding;
import io.activej.inject.impl.CompiledBindingLocator;
import io.activej.inject.util.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class Multibinders {
    private static final Multibinder<Object> ERROR_ON_DUPLICATE = (key, bindings) -> {
        throw new DIException(bindings.stream().map(Utils::getLocation).collect(Collectors.joining("\n\t", "Duplicate bindings for key " + key.getDisplayString() + ":\n\t", "\n")));
    };
    private static final Multibinder<Set<Object>> TO_SET = Multibinders.ofReducer((key, stream) -> {
        HashSet result = new HashSet();
        stream.forEach(result::addAll);
        return result;
    });
    private static final Multibinder<Map<Object, Object>> TO_MAP = Multibinders.ofReducer((key, stream) -> {
        HashMap result = new HashMap();
        stream.forEach(map -> map.forEach((k, v) -> result.merge(k, v, ($, $2) -> {
            throw new DIException("Duplicate key " + k + " while merging maps for key " + key.getDisplayString());
        })));
        return result;
    });

    public static <T> Multibinder<T> errorOnDuplicate() {
        return ERROR_ON_DUPLICATE;
    }

    public static <T> Multibinder<T> ofReducer(final BiFunction<Key<T>, Stream<T>, T> reducerFunction) {
        return (key, bindings) -> new Binding<T>(bindings.stream().map(Binding::getDependencies).flatMap(Collection::stream).collect(Collectors.toSet())){

            @Override
            public CompiledBinding<T> compile(CompiledBindingLocator compiledBindingsLocator, boolean threadsafe, int scope, @Nullable Integer slot) {
                final CompiledBinding[] compiledBindings = (CompiledBinding[])bindings.stream().map(binding -> binding.compile(compiledBindingsLocator, true, scope, null)).toArray(CompiledBinding[]::new);
                return slot == null || bindings.stream().anyMatch(b -> b.getType() == BindingType.TRANSIENT) ? new CompiledBinding<T>(){

                    @Override
                    public T getInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        return reducerFunction.apply(key, Arrays.stream(compiledBindings).map(binding -> binding.getInstance(scopedInstances, synchronizedScope)));
                    }
                } : new AbstractCompiledBinding<T>(scope, slot){

                    @Override
                    protected T doCreateInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        return reducerFunction.apply(key, Arrays.stream(compiledBindings).map(binding -> binding.getInstance(scopedInstances, synchronizedScope)));
                    }
                };
            }
        };
    }

    public static <T> Multibinder<T> ofBinaryOperator(BinaryOperator<T> binaryOperator) {
        return Multibinders.ofReducer(($, stream) -> stream.reduce(binaryOperator).get());
    }

    public static <T> Multibinder<Set<T>> toSet() {
        return TO_SET;
    }

    public static <K, V> Multibinder<Map<K, V>> toMap() {
        return TO_MAP;
    }

    public static Multibinder<?> combinedMultibinder(Map<Key<?>, Multibinder<?>> multibinders) {
        return (key, bindings) -> multibinders.getOrDefault(key, ERROR_ON_DUPLICATE).multibind(key, bindings);
    }
}

