/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.binding;

import io.activej.inject.KeyPattern;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingTransformer;
import io.activej.inject.util.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class BindingTransformers {
    private static final BindingTransformer<Object> IDENTITY = (bindings, scope, key, binding) -> binding;

    public static <T> BindingTransformer<T> identity() {
        return IDENTITY;
    }

    public static BindingTransformer<?> combinedTransformer(Map<KeyPattern<?>, Set<BindingTransformer<?>>> transformers) {
        LinkedHashMap sorted = Utils.sortPatternsMap(transformers);
        return (bindings, scope, key, binding) -> {
            Binding result = binding;
            for (Map.Entry entry : sorted.entrySet()) {
                if (!((KeyPattern)entry.getKey()).match(key)) continue;
                for (BindingTransformer transformer : (Set)entry.getValue()) {
                    result = transformer.transform(bindings, scope, key, result);
                }
            }
            return result;
        };
    }
}

