/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject;

import io.activej.inject.Key;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public interface ResourceLocator {
    public <T> T getInstance(Key<T> var1);

    default public <T> T getInstance(Class<T> type) {
        return this.getInstance(Key.of(type));
    }

    @Nullable
    public <T> T getInstanceOrNull(Key<T> var1);

    @Nullable
    default public <T> T getInstanceOrNull(Class<T> type) {
        return this.getInstanceOrNull(Key.of(type));
    }

    default public <T> T getInstanceOr(Key<T> key, T defaultValue) {
        T instance = this.getInstanceOrNull(key);
        return instance != null ? instance : defaultValue;
    }

    default public <T> T getInstanceOr(Class<T> type, T defaultValue) {
        return this.getInstanceOr(Key.of(type), defaultValue);
    }

    default public <T> T getInstanceOrCreate(Key<T> key, Supplier<T> defaultValueFn) {
        T result = this.getInstanceOrNull(key);
        if (result != null) {
            return result;
        }
        return defaultValueFn.get();
    }

    default public <T> T getInstanceOrCreate(Class<T> type, Supplier<T> defaultValueFn) {
        return this.getInstanceOrCreate(Key.of(type), defaultValueFn);
    }
}

