/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject;

import io.activej.inject.Key;
import io.activej.inject.util.ReflectionUtils;
import io.activej.inject.util.TypeUtils;
import io.activej.types.IsAssignableUtils;
import io.activej.types.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public abstract class KeyPattern<T> {
    private final Type type;
    private final Predicate<?> qualifier;

    protected KeyPattern() {
        this.type = TypeUtils.simplifyType(this.getTypeParameter());
        this.qualifier = null;
    }

    protected KeyPattern(Object qualifier) {
        this.type = TypeUtils.simplifyType(this.getTypeParameter());
        this.qualifier = KeyPattern.predicateOf(qualifier);
    }

    protected KeyPattern(Predicate<?> qualifier) {
        this.type = TypeUtils.simplifyType(this.getTypeParameter());
        this.qualifier = qualifier;
    }

    KeyPattern(Type type, Predicate<?> qualifier) {
        this.type = TypeUtils.simplifyType(type);
        this.qualifier = qualifier;
    }

    public static <T> KeyPattern<T> create(Type type, Predicate<?> qualifier) {
        return new KeyPatternImpl(type, qualifier);
    }

    public static <T> KeyPattern<T> of(Class<T> type) {
        return new KeyPatternImpl(type, null);
    }

    public static <T> KeyPattern<T> of(Class<T> type, Object qualifier) {
        return new KeyPatternImpl(type, KeyPattern.predicateOf(qualifier));
    }

    public static <T> KeyPattern<T> ofType(Type type) {
        return new KeyPatternImpl(type, null);
    }

    public static <T> KeyPattern<T> ofType(Type type, Object qualifier) {
        return new KeyPatternImpl(type, KeyPattern.predicateOf(qualifier));
    }

    private static Predicate<Object> predicateOf(Object qualifier) {
        return q -> Objects.equals(q, qualifier);
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasQualifier() {
        return this.qualifier != null;
    }

    public boolean match(Key<?> key) {
        return IsAssignableUtils.isAssignable((Type)this.type, (Type)key.getType()) && (this.qualifier == null || this.qualifier.test(key.getQualifier()));
    }

    private Type getTypeParameter() {
        Type typeArgument = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Object outerInstance = ReflectionUtils.getOuterClassInstance(this);
        return outerInstance != null ? Types.bind((Type)typeArgument, (Map)Types.getAllTypeBindings(outerInstance.getClass())) : typeArgument;
    }

    public String toString() {
        return (String)(this.qualifier != null ? this.qualifier + " " : "") + this.type.getTypeName();
    }

    public static final class KeyPatternImpl<T>
    extends KeyPattern<T> {
        private KeyPatternImpl(Type type, Predicate<?> qualifierPredicate) {
            super(type, qualifierPredicate);
        }
    }
}

