/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.session;

import io.activej.common.Checks;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.session.ISessionStore;
import io.activej.promise.Promise;
import io.activej.reactor.AbstractReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import java.util.function.Function;

public final class SessionServlet<T>
extends AbstractReactive
implements AsyncServlet {
    private static final boolean CHECKS = Checks.isEnabled(SessionServlet.class);
    private final ISessionStore<T> store;
    private final Function<HttpRequest, String> sessionIdExtractor;
    private final AsyncServlet publicServlet;
    private final AsyncServlet privateServlet;

    private SessionServlet(Reactor reactor, ISessionStore<T> store, Function<HttpRequest, String> sessionIdExtractor, AsyncServlet publicServlet, AsyncServlet privateServlet) {
        super(reactor);
        this.store = store;
        this.sessionIdExtractor = sessionIdExtractor;
        this.publicServlet = publicServlet;
        this.privateServlet = privateServlet;
    }

    public static <T> SessionServlet<T> create(Reactor reactor, ISessionStore<T> store, String sessionIdCookie, AsyncServlet publicServlet, AsyncServlet privateServlet) {
        return new SessionServlet<T>(reactor, store, request -> request.getCookie(sessionIdCookie), publicServlet, privateServlet);
    }

    public static <T> SessionServlet<T> create(Reactor reactor, ISessionStore<T> store, Function<HttpRequest, String> sessionIdExtractor, AsyncServlet publicServlet, AsyncServlet privateServlet) {
        return new SessionServlet<T>(reactor, store, sessionIdExtractor, publicServlet, privateServlet);
    }

    @Override
    public Promise<HttpResponse> serve(HttpRequest request) throws Exception {
        String id;
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if ((id = this.sessionIdExtractor.apply(request)) == null) {
            return this.publicServlet.serve(request);
        }
        return this.store.get(id).then(sessionObject -> {
            if (sessionObject != null) {
                request.attach(sessionObject);
                return this.privateServlet.serve(request);
            }
            return this.publicServlet.serve(request);
        });
    }
}

