/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.session;

import io.activej.common.Checks;
import io.activej.common.builder.AbstractBuilder;
import io.activej.common.time.CurrentTimeProvider;
import io.activej.http.session.ISessionStore;
import io.activej.promise.Promise;
import io.activej.reactor.AbstractReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class InMemorySessionStore<T>
extends AbstractReactive
implements ISessionStore<T> {
    private static final boolean CHECKS = Checks.isEnabled(InMemorySessionStore.class);
    private final Map<String, TWithTimestamp> store = new HashMap<String, TWithTimestamp>();
    @Nullable
    private Duration sessionLifetime;
    CurrentTimeProvider now = CurrentTimeProvider.ofSystem();

    private InMemorySessionStore(Reactor reactor) {
        super(reactor);
    }

    public static <T> InMemorySessionStore<T> create(Reactor reactor) {
        return (InMemorySessionStore)InMemorySessionStore.builder(reactor).build();
    }

    public static <T> Builder builder(Reactor reactor) {
        return new InMemorySessionStore<T>(reactor).new Builder();
    }

    @Override
    public Promise<Void> save(String sessionId, T sessionObject) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        this.store.put(sessionId, new TWithTimestamp(sessionObject, this.now.currentTimeMillis()));
        return Promise.complete();
    }

    @Override
    public Promise<@Nullable T> get(String sessionId) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        long timestamp = this.now.currentTimeMillis();
        TWithTimestamp tWithTimestamp = this.store.get(sessionId);
        if (tWithTimestamp == null) {
            return Promise.of(null);
        }
        if (this.sessionLifetime != null && tWithTimestamp.timestamp + this.sessionLifetime.toMillis() < timestamp) {
            this.store.remove(sessionId);
            return Promise.of(null);
        }
        tWithTimestamp.timestamp = timestamp;
        return Promise.of(tWithTimestamp.value);
    }

    @Override
    public Promise<Void> remove(String sessionId) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        this.store.remove(sessionId);
        return Promise.complete();
    }

    @Override
    @Nullable
    public Duration getSessionLifetimeHint() {
        return this.sessionLifetime;
    }

    public final class Builder
    extends AbstractBuilder<Builder, InMemorySessionStore<T>> {
        private Builder() {
        }

        public Builder withLifetime(Duration sessionLifetime) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            InMemorySessionStore.this.sessionLifetime = sessionLifetime;
            return this;
        }

        protected InMemorySessionStore<T> doBuild() {
            return InMemorySessionStore.this;
        }
    }

    public class TWithTimestamp {
        final T value;
        long timestamp;

        public TWithTimestamp(T value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }
    }
}

