/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.loader;

import io.activej.bytebuf.ByteBuf;
import io.activej.http.loader.CacheStaticLoader;
import io.activej.http.loader.ClassPathStaticLoader;
import io.activej.http.loader.FileReaderStaticLoader;
import io.activej.http.loader.ResourceNotFoundException;
import io.activej.promise.Promise;
import io.activej.reactor.Reactor;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public interface IStaticLoader {
    public Promise<ByteBuf> load(String var1);

    default public IStaticLoader filter(Predicate<String> predicate) {
        return path -> predicate.test(path) ? this.load(path) : Promise.ofException((Exception)new ResourceNotFoundException("Resource '" + path + "' has been filtered out"));
    }

    default public IStaticLoader map(UnaryOperator<String> fn) {
        return path -> this.load((String)fn.apply(path));
    }

    default public IStaticLoader subdirectory(String subdirectory) {
        Object folder = subdirectory.endsWith("/") ? subdirectory : subdirectory + "/";
        return this.map(arg_0 -> IStaticLoader.lambda$subdirectory$2((String)folder, arg_0));
    }

    default public IStaticLoader cached(Reactor reactor) {
        return IStaticLoader.cacheOf(reactor, this);
    }

    default public IStaticLoader cached(Reactor reactor, Map<String, byte[]> map) {
        return IStaticLoader.cacheOf(reactor, this, map);
    }

    public static IStaticLoader cacheOf(Reactor reactor, IStaticLoader loader) {
        return IStaticLoader.cacheOf(reactor, loader, new HashMap<String, byte[]>());
    }

    public static IStaticLoader cacheOf(Reactor reactor, IStaticLoader loader, Map<String, byte[]> map) {
        return IStaticLoader.cacheOf(reactor, loader, map::get, map::put);
    }

    public static IStaticLoader cacheOf(Reactor reactor, IStaticLoader loader, Function<String, byte[]> get, BiConsumer<String, byte[]> put) {
        return new CacheStaticLoader(reactor, loader, get, put);
    }

    public static IStaticLoader ofClassPath(Reactor reactor, Executor executor, String root) {
        return ClassPathStaticLoader.create(reactor, executor, root);
    }

    public static IStaticLoader ofClassPath(Reactor reactor, Executor executor, ClassLoader classLoader, String root) {
        return ClassPathStaticLoader.create(reactor, executor, classLoader, root);
    }

    public static IStaticLoader ofPath(Reactor reactor, Executor executor, Path dir) {
        return new FileReaderStaticLoader(reactor, executor, dir);
    }

    private static /* synthetic */ String lambda$subdirectory$2(String folder, String name) {
        return folder + name;
    }
}

