/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.loader;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.csp.file.ChannelFileReader;
import io.activej.http.loader.IStaticLoader;
import io.activej.http.loader.ResourceIsADirectoryException;
import io.activej.http.loader.ResourceNotFoundException;
import io.activej.promise.Promise;
import io.activej.reactor.AbstractReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.Executor;

public class FileReaderStaticLoader
extends AbstractReactive
implements IStaticLoader {
    private static final boolean CHECKS = Checks.isEnabled(FileReaderStaticLoader.class);
    private final Executor executor;
    private final Path root;

    FileReaderStaticLoader(Reactor reactor, Executor executor, Path root) {
        super(reactor);
        this.executor = executor;
        this.root = root;
    }

    @Override
    public Promise<ByteBuf> load(String path) {
        Path file;
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if (!(file = this.root.resolve(path).normalize()).startsWith(this.root)) {
            return Promise.ofException((Exception)new ResourceNotFoundException("Could not find '" + path + "'"));
        }
        return Promise.ofBlocking((Executor)this.executor, () -> {
            if (Files.isRegularFile(file, new LinkOption[0])) {
                return;
            }
            if (Files.isDirectory(file, new LinkOption[0])) {
                throw new ResourceIsADirectoryException("Resource '" + path + "' is a directory");
            }
            throw new ResourceNotFoundException("Could not find '" + path + "'");
        }).then(() -> ChannelFileReader.open((Executor)this.executor, (Path)file)).then(cfr -> cfr.toCollector(ByteBufs.collector()));
    }
}

