/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.decoder;

import io.activej.common.collection.CollectionUtils;
import io.activej.http.decoder.DecodeError;
import java.util.List;
import java.util.function.Predicate;

public interface Validator<T> {
    public List<DecodeError> validate(T var1);

    default public Validator<T> and(Validator<T> next) {
        if (this == Validator.alwaysOk()) {
            return next;
        }
        if (next == Validator.alwaysOk()) {
            return this;
        }
        return value -> {
            List<DecodeError> thisErrors = this.validate(value);
            List<DecodeError> nextErrors = next.validate(value);
            return CollectionUtils.concat(thisErrors, nextErrors);
        };
    }

    default public Validator<T> then(Validator<T> next) {
        if (this == Validator.alwaysOk()) {
            return next;
        }
        if (next == Validator.alwaysOk()) {
            return this;
        }
        return value -> {
            List<DecodeError> thisErrors = this.validate(value);
            return thisErrors.isEmpty() ? next.validate(value) : thisErrors;
        };
    }

    public static <T> Validator<T> alwaysOk() {
        return value -> List.of();
    }

    @SafeVarargs
    public static <T> Validator<T> sequence(Validator<T> ... validators) {
        return Validator.sequence(List.of(validators));
    }

    public static <T> Validator<T> sequence(List<Validator<T>> validators) {
        return validators.stream().reduce(Validator.alwaysOk(), Validator::then);
    }

    @SafeVarargs
    public static <T> Validator<T> of(Validator<T> ... validators) {
        return Validator.of(List.of(validators));
    }

    public static <T> Validator<T> of(List<Validator<T>> validators) {
        return validators.stream().reduce(Validator.alwaysOk(), Validator::and);
    }

    public static <T> Validator<T> of(Predicate<T> predicate, String template) {
        return value -> predicate.test(value) ? List.of() : List.of(DecodeError.of(template, value));
    }
}

