/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.decoder;

import io.activej.common.collection.Either;
import io.activej.http.HttpRequest;
import io.activej.http.decoder.AbstractDecoder;
import io.activej.http.decoder.DecodeErrors;
import io.activej.http.decoder.Decoder;
import io.activej.http.decoder.Mapper;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;

public class Decoders {
    public static final String REQUIRED_GET_PARAM = "Required GET param: %s";
    public static final String REQUIRED_POST_PARAM = "Required POST param: %s";
    public static final String REQUIRED_PATH_PARAM = "Required path param: %s";
    public static final String REQUIRED_COOKIE = "Required cookie: %s";

    private static <T> Decoder<T> create(final String paramName, final Mapper<String, T> fn, final BiFunction<HttpRequest, String, String> paramSupplier, final String message) {
        return new AbstractDecoder<T>(paramName){

            @Override
            public Either<T, DecodeErrors> decode(HttpRequest request) {
                String str = (String)paramSupplier.apply(request, paramName);
                return str != null ? fn.map(str).mapRight(DecodeErrors::of) : Either.right((Object)DecodeErrors.of(message, paramName));
            }
        };
    }

    private static <T> Decoder<T> create(final String paramName, final Mapper<String, T> fn, final BiFunction<HttpRequest, String, String> paramSupplier, final @Nullable T defaultValue) {
        return new AbstractDecoder<T>(paramName){

            @Override
            public Either<T, DecodeErrors> decode(HttpRequest request) {
                String str = (String)paramSupplier.apply(request, paramName);
                return str != null ? fn.map(str).mapRight(DecodeErrors::of) : Either.left((Object)defaultValue);
            }
        };
    }

    public static Decoder<String> ofGet(String paramName) {
        return Decoders.ofGet(paramName, Either::left);
    }

    public static Decoder<String> ofGet(String paramName, String defaultValue) {
        return Decoders.ofGet(paramName, Either::left, defaultValue);
    }

    public static <T> Decoder<T> ofGet(String paramName, Mapper<String, T> fn) {
        return Decoders.create(paramName, fn, HttpRequest::getQueryParameter, REQUIRED_GET_PARAM);
    }

    public static <T> Decoder<T> ofGet(String paramName, Mapper<String, T> fn, @Nullable T defaultValue) {
        return Decoders.create(paramName, fn, HttpRequest::getQueryParameter, defaultValue);
    }

    public static Decoder<String> ofPost(String paramName) {
        return Decoders.ofPost(paramName, Either::left);
    }

    public static Decoder<String> ofPost(String paramName, String defaultValue) {
        return Decoders.ofPost(paramName, Either::left, defaultValue);
    }

    public static <T> Decoder<T> ofPost(String paramName, Mapper<String, T> fn) {
        return Decoders.create(paramName, fn, HttpRequest::getPostParameter, REQUIRED_POST_PARAM);
    }

    public static <T> Decoder<T> ofPost(String paramName, Mapper<String, T> fn, @Nullable T defaultValue) {
        return Decoders.create(paramName, fn, HttpRequest::getPostParameter, defaultValue);
    }

    public static Decoder<String> ofPath(String paramName) {
        return Decoders.ofPath(paramName, Either::left);
    }

    public static Decoder<String> ofPath(String paramName, String defaultValue) {
        return Decoders.ofPath(paramName, Either::left, defaultValue);
    }

    public static <T> Decoder<T> ofPath(String paramName, Mapper<String, T> fn) {
        return Decoders.create(paramName, fn, HttpRequest::getPathParameter, REQUIRED_PATH_PARAM);
    }

    public static <T> Decoder<T> ofPath(String paramName, Mapper<String, T> fn, @Nullable T defaultValue) {
        return Decoders.create(paramName, fn, HttpRequest::getPathParameter, defaultValue);
    }

    public static Decoder<String> ofCookie(String paramName) {
        return Decoders.ofCookie(paramName, Either::left);
    }

    public static Decoder<String> ofCookie(String paramName, String defaultValue) {
        return Decoders.ofCookie(paramName, Either::left, defaultValue);
    }

    public static <T> Decoder<T> ofCookie(String paramName, Mapper<String, T> fn) {
        return Decoders.create(paramName, fn, HttpRequest::getCookie, REQUIRED_COOKIE);
    }

    public static <T> Decoder<T> ofCookie(String paramName, Mapper<String, T> fn, @Nullable T defaultValue) {
        return Decoders.create(paramName, fn, HttpRequest::getCookie, defaultValue);
    }
}

