/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.decoder;

import io.activej.common.collection.Either;
import io.activej.common.tuple.TupleConstructor1;
import io.activej.common.tuple.TupleConstructor2;
import io.activej.common.tuple.TupleConstructor3;
import io.activej.common.tuple.TupleConstructor4;
import io.activej.common.tuple.TupleConstructor5;
import io.activej.common.tuple.TupleConstructor6;
import io.activej.http.HttpRequest;
import io.activej.http.decoder.AbstractDecoder;
import io.activej.http.decoder.DecodeError;
import io.activej.http.decoder.DecodeErrors;
import io.activej.http.decoder.DecodeException;
import io.activej.http.decoder.Mapper;
import io.activej.http.decoder.Validator;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public interface Decoder<T> {
    public Either<T, DecodeErrors> decode(HttpRequest var1);

    @Nullable
    default public T decodeOrNull(HttpRequest request) {
        return (T)this.decode(request).getLeft();
    }

    default public T decodeOrThrow(HttpRequest request) throws DecodeException {
        Either<T, DecodeErrors> either = this.decode(request);
        if (either.isLeft()) {
            return (T)either.getLeft();
        }
        throw new DecodeException((DecodeErrors)either.getRight());
    }

    public String getId();

    default public Decoder<T> withId(final String id) {
        return new Decoder<T>(){

            @Override
            public Either<T, DecodeErrors> decode(HttpRequest request) {
                return Decoder.this.decode(request);
            }

            @Override
            public String getId() {
                return id;
            }
        };
    }

    default public <V> Decoder<V> map(final Mapper<T, V> fn) {
        return new AbstractDecoder<V>(this.getId()){

            @Override
            public Either<V, DecodeErrors> decode(HttpRequest request) {
                return Decoder.this.decode(request).flatMapLeft(value -> fn.map(value).mapRight(DecodeErrors::of));
            }
        };
    }

    default public Decoder<T> validate(Predicate<T> predicate, String error) {
        return this.validate(Validator.of(predicate, error));
    }

    default public Decoder<T> validate(final Validator<T> validator) {
        return new AbstractDecoder<T>(this.getId()){

            @Override
            public Either<T, DecodeErrors> decode(HttpRequest request) {
                Either decodedValue = Decoder.this.decode(request);
                if (decodedValue.isRight()) {
                    return decodedValue;
                }
                List<DecodeError> errors = validator.validate(decodedValue.getLeft());
                if (errors.isEmpty()) {
                    return decodedValue;
                }
                return Either.right((Object)DecodeErrors.of(errors));
            }
        };
    }

    public static <V> Decoder<V> create(final Mapper<Object[], V> fn, final Decoder<?> ... decoders) {
        return new AbstractDecoder<V>(""){

            @Override
            public Either<V, DecodeErrors> decode(HttpRequest request) {
                Object[] args = new Object[decoders.length];
                DecodeErrors.Builder errorsBuilder = DecodeErrors.builder();
                for (int i = 0; i < decoders.length; ++i) {
                    Decoder decoder = decoders[i];
                    Either decoded = decoder.decode(request);
                    if (decoded.isLeft()) {
                        args[i] = decoded.getLeft();
                        continue;
                    }
                    errorsBuilder.with(decoder.getId(), (DecodeErrors)decoded.getRight());
                }
                DecodeErrors errors = (DecodeErrors)errorsBuilder.build();
                if (errors.hasErrors()) {
                    return Either.right((Object)errors);
                }
                return fn.map(args).mapRight(DecodeErrors::of);
            }
        };
    }

    public static <R, T1> Decoder<R> of(TupleConstructor1<T1, R> constructor, Decoder<T1> decoder1) {
        return Decoder.create(Mapper.of(params -> constructor.create(params[0])), decoder1);
    }

    public static <R, T1, T2> Decoder<R> of(TupleConstructor2<T1, T2, R> constructor, Decoder<T1> decoder1, Decoder<T2> decoder2) {
        return Decoder.create(Mapper.of(params -> constructor.create(params[0], params[1])), decoder1, decoder2);
    }

    public static <R, T1, T2, T3> Decoder<R> of(TupleConstructor3<T1, T2, T3, R> constructor, Decoder<T1> decoder1, Decoder<T2> decoder2, Decoder<T3> decoder3) {
        return Decoder.create(Mapper.of(params -> constructor.create(params[0], params[1], params[2])), decoder1, decoder2, decoder3);
    }

    public static <R, T1, T2, T3, T4> Decoder<R> of(TupleConstructor4<T1, T2, T3, T4, R> constructor, Decoder<T1> decoder1, Decoder<T2> decoder2, Decoder<T3> decoder3, Decoder<T4> decoder4) {
        return Decoder.create(Mapper.of(params -> constructor.create(params[0], params[1], params[2], params[3])), decoder1, decoder2, decoder3, decoder4);
    }

    public static <R, T1, T2, T3, T4, T5> Decoder<R> of(TupleConstructor5<T1, T2, T3, T4, T5, R> constructor, Decoder<T1> decoder1, Decoder<T2> decoder2, Decoder<T3> decoder3, Decoder<T4> decoder4, Decoder<T5> decoder5) {
        return Decoder.create(Mapper.of(params -> constructor.create(params[0], params[1], params[2], params[3], params[4])), decoder1, decoder2, decoder3, decoder4, decoder5);
    }

    public static <R, T1, T2, T3, T4, T5, T6> Decoder<R> of(TupleConstructor6<T1, T2, T3, T4, T5, T6, R> constructor, Decoder<T1> decoder1, Decoder<T2> decoder2, Decoder<T3> decoder3, Decoder<T4> decoder4, Decoder<T5> decoder5, Decoder<T6> decoder6) {
        return Decoder.create(Mapper.of(params -> constructor.create(params[0], params[1], params[2], params[3], params[5], params[6])), decoder1, decoder2, decoder3, decoder4, decoder5, decoder6);
    }
}

