/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.decoder;

import io.activej.common.builder.AbstractBuilder;
import io.activej.http.decoder.DecodeError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class DecodeErrors {
    private static final String DEFAULT_SEPARATOR = ".";
    @Nullable
    private List<DecodeError> errors;
    @Nullable
    private Map<String, DecodeErrors> children;

    private DecodeErrors() {
    }

    public static DecodeErrors create() {
        return (DecodeErrors)DecodeErrors.builder().build();
    }

    public static DecodeErrors of(String message, Object ... args) {
        return (DecodeErrors)DecodeErrors.builder().with(DecodeError.of(message, args)).build();
    }

    public static DecodeErrors of(DecodeError error) {
        return (DecodeErrors)DecodeErrors.builder().with(error).build();
    }

    public static DecodeErrors of(List<DecodeError> errors) {
        return (DecodeErrors)DecodeErrors.builder().with(errors).build();
    }

    public static Builder builder() {
        return new DecodeErrors().new Builder();
    }

    public DecodeErrors merge(DecodeErrors another) {
        if (another.errors != null) {
            if (this.errors == null) {
                this.errors = new ArrayList<DecodeError>(another.errors);
            } else {
                this.errors.addAll(another.errors);
            }
        }
        if (another.children != null) {
            if (this.children == null) {
                this.children = new HashMap<String, DecodeErrors>(another.children);
            } else {
                for (String key : another.children.keySet()) {
                    this.children.merge(key, another.children.get(key), DecodeErrors::merge);
                }
            }
        }
        return this;
    }

    public boolean hasErrors() {
        return this.errors != null || this.children != null;
    }

    public List<DecodeError> getErrors() {
        return this.errors != null ? this.errors : List.of();
    }

    public Set<String> getChildren() {
        return this.children != null ? this.children.keySet() : Set.of();
    }

    public DecodeErrors getChild(String id) {
        return this.children != null ? this.children.get(id) : null;
    }

    public Map<String, String> toMap() {
        return this.toMap(String::format);
    }

    public Map<String, String> toMap(String separator) {
        return this.toMap(String::format, separator);
    }

    public Map<String, List<String>> toMultimap() {
        return this.toMultimap(String::format);
    }

    public Map<String, List<String>> toMultimap(String separator) {
        return this.toMultimap(String::format, separator);
    }

    public Map<String, String> toMap(BiFunction<String, Object[], String> formatter) {
        return this.toMap(formatter, DEFAULT_SEPARATOR);
    }

    public Map<String, String> toMap(BiFunction<String, Object[], String> formatter, String separator) {
        HashMap<String, String> map = new HashMap<String, String>();
        DecodeErrors.toMapImpl(this, map, "", formatter, separator);
        return map;
    }

    public Map<String, List<String>> toMultimap(BiFunction<String, Object[], String> formatter, String separator) {
        HashMap<String, List<String>> multimap = new HashMap<String, List<String>>();
        DecodeErrors.toMultimapImpl(this, multimap, "", formatter, separator);
        return multimap;
    }

    public Map<String, List<String>> toMultimap(BiFunction<String, Object[], String> formatter) {
        return this.toMultimap(formatter, DEFAULT_SEPARATOR);
    }

    private static void toMultimapImpl(DecodeErrors errors, Map<String, List<String>> multimap, String prefix, BiFunction<String, Object[], String> formatter, String separator) {
        if (errors.errors != null) {
            multimap.put(prefix, errors.errors.stream().map(error -> (String)formatter.apply(error.message, error.getArgs())).collect(Collectors.toList()));
        }
        if (errors.children != null) {
            errors.children.forEach((id, child) -> DecodeErrors.toMultimapImpl(child, multimap, (String)(prefix.isEmpty() ? "" : prefix + separator) + id, formatter, separator));
        }
    }

    private static void toMapImpl(DecodeErrors errors, Map<String, String> map, String prefix, BiFunction<String, Object[], String> formatter, String separator) {
        if (errors.errors != null) {
            DecodeError error = errors.errors.get(0);
            map.put(prefix, formatter.apply(error.message, error.getArgs()));
        }
        if (errors.children != null) {
            errors.children.forEach((id, child) -> DecodeErrors.toMapImpl(child, map, (String)(prefix.isEmpty() ? "" : prefix + separator) + id, formatter, separator));
        }
    }

    private void setError(DecodeError error) {
        if (this.errors == null) {
            this.errors = new ArrayList<DecodeError>();
        }
        this.errors.add(error);
    }

    public final class Builder
    extends AbstractBuilder<Builder, DecodeErrors> {
        private Builder() {
        }

        public Builder with(DecodeError error) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            DecodeErrors.this.setError(error);
            return this;
        }

        public Builder with(List<DecodeError> errors) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            if (DecodeErrors.this.errors == null) {
                DecodeErrors.this.errors = new ArrayList<DecodeError>();
            }
            DecodeErrors.this.errors.addAll(errors);
            return this;
        }

        public Builder with(String id, DecodeErrors nestedError) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            if (DecodeErrors.this.children == null) {
                DecodeErrors.this.children = new HashMap<String, DecodeErrors>();
            }
            DecodeErrors.this.children.merge(id, nestedError, DecodeErrors::merge);
            return this;
        }

        public Builder with(String id, DecodeError nestedError) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            if (DecodeErrors.this.children == null) {
                DecodeErrors.this.children = new HashMap<String, DecodeErrors>();
            }
            DecodeErrors.this.children.computeIfAbsent(id, $ -> new DecodeErrors()).setError(nestedError);
            return this;
        }

        protected DecodeErrors doBuild() {
            return DecodeErrors.this;
        }
    }
}

