/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.builder.Builder;
import io.activej.common.initializer.WithInitializer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class UrlBuilder
implements Builder<String>,
WithInitializer<UrlBuilder> {
    @Nullable
    private String scheme;
    @Nullable
    private String userinfo;
    @Nullable
    private String host;
    private int port = 0;
    private final List<String> path = new ArrayList<String>();
    private final List<QueryKV> query = new ArrayList<QueryKV>();
    @Nullable
    private String fragment;

    private UrlBuilder() {
    }

    public static UrlBuilder create() {
        return new UrlBuilder();
    }

    public static UrlBuilder http(String host) {
        return UrlBuilder.create().withScheme("http").withHost(host);
    }

    public static UrlBuilder http(String host, int port) {
        return UrlBuilder.create().withScheme("http").withHost(host, port);
    }

    public static UrlBuilder https(String host) {
        return UrlBuilder.create().withScheme("https").withHost(host);
    }

    public static UrlBuilder https(String host, int port) {
        return UrlBuilder.create().withScheme("https").withHost(host, port);
    }

    public UrlBuilder withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public UrlBuilder withAuth(String userinfo) {
        this.userinfo = userinfo;
        return this;
    }

    public UrlBuilder withHost(String host) {
        this.host = host;
        return this;
    }

    public UrlBuilder withHost(String host, int port) {
        this.host = host;
        this.port = port;
        return this;
    }

    public UrlBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public UrlBuilder withPath(String part) {
        this.path.add(part);
        return this;
    }

    public UrlBuilder withPath(String ... parts) {
        return this.withPath(Arrays.asList(parts));
    }

    public UrlBuilder withPath(List<String> parts) {
        this.path.addAll(parts);
        return this;
    }

    public UrlBuilder withQuery(String key, Object value) {
        this.query.add(new QueryKV(key, value));
        return this;
    }

    public UrlBuilder withFragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public String build() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (this.host != null) {
            sb.append("//");
            if (this.userinfo != null) {
                sb.append(this.userinfo).append('@');
            }
            sb.append(this.host);
            if (this.port > 0) {
                sb.append(':').append(this.port);
            }
            sb.append('/');
        }
        if (!this.path.isEmpty()) {
            for (String p : this.path) {
                sb.append(UrlBuilder.urlEncode(p)).append('/');
            }
            sb.setLength(sb.length() - 1);
        }
        if (!this.query.isEmpty()) {
            sb.append('?');
            for (QueryKV queryKV : this.query) {
                sb.append(UrlBuilder.urlEncode(queryKV.k)).append('=').append(UrlBuilder.urlEncode(queryKV.v.toString())).append('&');
            }
            sb.setLength(sb.length() - 1);
        }
        if (this.fragment != null) {
            sb.append('#').append(this.fragment);
        }
        return sb.toString();
    }

    private static String urlEncode(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }

    private record QueryKV(String k, Object v) {
    }
}

