/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.csp.supplier.ChannelSupplier;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.IHttpClient;
import io.activej.promise.Promise;
import io.activej.reactor.ImplicitlyReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;

public final class StubHttpClient
extends ImplicitlyReactive
implements IHttpClient {
    private final AsyncServlet servlet;

    private StubHttpClient(AsyncServlet servlet) {
        this.servlet = servlet;
    }

    public static StubHttpClient of(AsyncServlet servlet) {
        return new StubHttpClient(servlet);
    }

    @Override
    public Promise<HttpResponse> request(HttpRequest request) {
        Promise servletResult;
        Reactive.checkInReactorThread((Reactive)this);
        try {
            servletResult = this.servlet.serve(request);
        }
        catch (Exception e) {
            servletResult = Promise.ofException((Exception)e);
        }
        return servletResult.whenComplete(request::recycleBody).then(res -> {
            ChannelSupplier bodyStream = res.bodyStream;
            Reactor reactor = Reactor.getCurrentReactor();
            if (bodyStream != null) {
                res.bodyStream = bodyStream.withEndOfStream(eos -> eos.whenComplete(() -> reactor.post(res::recycle)));
            } else {
                reactor.post(res::recycle);
            }
            return Promise.of((Object)res);
        });
    }
}

