/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.common.Checks;
import io.activej.common.builder.AbstractBuilder;
import io.activej.http.AsyncServlet;
import io.activej.http.ContentType;
import io.activej.http.HttpError;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.MediaType;
import io.activej.http.MediaTypes;
import io.activej.http.loader.IStaticLoader;
import io.activej.http.loader.ResourceIsADirectoryException;
import io.activej.http.loader.ResourceNotFoundException;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import io.activej.reactor.AbstractReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public final class StaticServlet
extends AbstractReactive
implements AsyncServlet {
    private static final boolean CHECKS = Checks.isEnabled(StaticServlet.class);
    public static final Charset DEFAULT_TXT_ENCODING = StandardCharsets.UTF_8;
    private final IStaticLoader resourceLoader;
    private Function<String, ContentType> contentTypeResolver = StaticServlet::getContentType;
    private Function<HttpRequest, @Nullable String> pathMapper = HttpRequest::getRelativePath;
    private Supplier<HttpResponse.Builder> responseBuilderSupplier = HttpResponse::ok200;
    private final Set<String> indexResources = new LinkedHashSet<String>();
    @Nullable
    private String defaultResource;

    private StaticServlet(Reactor reactor, IStaticLoader resourceLoader) {
        super(reactor);
        this.resourceLoader = resourceLoader;
    }

    public static StaticServlet create(Reactor reactor, IStaticLoader resourceLoader) {
        return (StaticServlet)StaticServlet.builder(reactor, resourceLoader).build();
    }

    public static StaticServlet create(Reactor reactor, IStaticLoader resourceLoader, String page) {
        return (StaticServlet)StaticServlet.builder(reactor, resourceLoader).withMappingTo(page).build();
    }

    public static StaticServlet ofClassPath(Reactor reactor, Executor executor, String path) {
        return (StaticServlet)StaticServlet.builder(reactor, IStaticLoader.ofClassPath(reactor, executor, path)).build();
    }

    public static StaticServlet ofPath(Reactor reactor, Executor executor, Path path) {
        return (StaticServlet)StaticServlet.builder(reactor, IStaticLoader.ofPath(reactor, executor, path)).build();
    }

    public static Builder builder(Reactor reactor, IStaticLoader resourceLoader) {
        return new StaticServlet(reactor, resourceLoader).new Builder();
    }

    public static ContentType getContentType(String path) {
        int pos = path.lastIndexOf(46);
        if (pos == -1) {
            return ContentType.of(MediaTypes.OCTET_STREAM);
        }
        String ext = path.substring(pos + 1);
        MediaType mime = MediaTypes.getByExtension(ext);
        if (mime == null) {
            mime = MediaTypes.OCTET_STREAM;
        }
        ContentType type = mime.isTextType() ? ContentType.of(mime, DEFAULT_TXT_ENCODING) : ContentType.of(mime);
        return type;
    }

    private Promise<HttpResponse> createHttpResponse(ByteBuf buf, ContentType contentType) {
        return ((HttpResponse.Builder)((HttpResponse.Builder)this.responseBuilderSupplier.get().withBody(buf)).withHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType(contentType))).toPromise();
    }

    @Override
    public Promise<HttpResponse> serve(HttpRequest request) {
        String mappedPath;
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if ((mappedPath = this.pathMapper.apply(request)) == null) {
            return Promise.ofException((Exception)HttpError.notFound404());
        }
        ContentType contentType = this.contentTypeResolver.apply(mappedPath);
        return Promise.complete().then(() -> mappedPath.endsWith("/") || mappedPath.isEmpty() ? this.tryLoadIndexResource(mappedPath) : this.resourceLoader.load(mappedPath).then(byteBuf -> this.createHttpResponse((ByteBuf)byteBuf, contentType)).then((value, e) -> {
            if (e instanceof ResourceIsADirectoryException) {
                return this.tryLoadIndexResource(mappedPath);
            }
            return Promise.of((Object)value, (Exception)e);
        })).then(Promise::of, e -> e instanceof ResourceNotFoundException ? this.tryLoadDefaultResource() : Promise.ofException((Exception)HttpError.ofCode(400, e)));
    }

    private Promise<HttpResponse> tryLoadIndexResource(String mappedPath) {
        String dirPath = mappedPath.endsWith("/") || mappedPath.isEmpty() ? mappedPath : mappedPath + "/";
        return Promises.first(this.indexResources.stream().map(indexResource -> () -> this.resourceLoader.load(dirPath + indexResource).then(byteBuf -> this.createHttpResponse((ByteBuf)byteBuf, this.contentTypeResolver.apply((String)indexResource))))).mapException(e -> new ResourceNotFoundException("Could not find '" + mappedPath + "'", (Throwable)e));
    }

    private Promise<HttpResponse> tryLoadDefaultResource() {
        return this.defaultResource != null ? this.resourceLoader.load(this.defaultResource).then(buf -> this.createHttpResponse((ByteBuf)buf, this.contentTypeResolver.apply(this.defaultResource))) : Promise.ofException((Exception)HttpError.notFound404());
    }

    public final class Builder
    extends AbstractBuilder<Builder, StaticServlet> {
        private Builder() {
        }

        public Builder withContentType(ContentType contentType) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withContentTypeResolver($ -> contentType);
        }

        public Builder withContentTypeResolver(Function<String, ContentType> contentTypeResolver) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            StaticServlet.this.contentTypeResolver = contentTypeResolver;
            return this;
        }

        public Builder withMapping(Function<HttpRequest, String> fn) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            StaticServlet.this.pathMapper = fn;
            return this;
        }

        public Builder withMappingTo(String path) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            if (StaticServlet.this.contentTypeResolver == StaticServlet::getContentType) {
                this.withContentType(StaticServlet.getContentType(path));
            }
            return this.withMapping($ -> path);
        }

        public Builder withMappingNotFoundTo(String defaultResource) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            StaticServlet.this.defaultResource = defaultResource;
            return this;
        }

        public Builder withIndexResources(String ... indexResources) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            StaticServlet.this.indexResources.addAll(List.of(indexResources));
            return this;
        }

        public Builder withIndexHtml() {
            Builder.checkNotBuilt((AbstractBuilder)this);
            StaticServlet.this.indexResources.add("index.html");
            return this;
        }

        public Builder withResponse(Supplier<HttpResponse.Builder> responseBuilderSupplier) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            StaticServlet.this.responseBuilderSupplier = responseBuilderSupplier;
            return this;
        }

        protected StaticServlet doBuild() {
            return StaticServlet.this;
        }
    }
}

