/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.Checks;
import io.activej.common.builder.AbstractBuilder;
import io.activej.common.initializer.WithInitializer;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpError;
import io.activej.http.HttpMethod;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.IWebSocket;
import io.activej.http.Protocol;
import io.activej.http.WebSocketServlet;
import io.activej.promise.Promise;
import io.activej.reactor.AbstractReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class RoutingServlet
extends AbstractReactive
implements AsyncServlet,
WithInitializer<RoutingServlet> {
    private static final boolean CHECKS = Checks.isEnabled(RoutingServlet.class);
    private static final String ROOT = "/";
    private static final String STAR = "*";
    private static final String WILDCARD = "/*";
    private static final int WS_ORDINAL = HttpMethod.values().length;
    private static final int ANY_HTTP_ORDINAL = WS_ORDINAL + 1;
    private final AsyncServlet[] servlets = new AsyncServlet[ANY_HTTP_ORDINAL + 1];
    private final AsyncServlet[] fallbackServlets = new AsyncServlet[ANY_HTTP_ORDINAL + 1];
    private final Map<String, RoutingServlet> routes = new HashMap<String, RoutingServlet>();
    private final Map<String, RoutingServlet> parameters = new HashMap<String, RoutingServlet>();

    private RoutingServlet(Reactor reactor) {
        super(reactor);
    }

    public static Builder builder(Reactor reactor) {
        return new RoutingServlet(reactor).new Builder();
    }

    public static RoutingServlet merge(RoutingServlet ... servlets) {
        return RoutingServlet.merge(Arrays.asList(servlets));
    }

    public static RoutingServlet merge(List<RoutingServlet> servlets) {
        Checks.checkArgument((servlets.size() > 1 ? 1 : 0) != 0, (Object)"Nothing to merge");
        Reactor reactor = servlets.get((int)0).reactor;
        for (RoutingServlet routingServlet : servlets) {
            Checks.checkArgument((reactor == routingServlet.reactor ? 1 : 0) != 0, (Object)"Different reactors");
        }
        RoutingServlet merged = new RoutingServlet(reactor);
        for (RoutingServlet servlet : servlets) {
            RoutingServlet.mergeInto(merged, servlet);
        }
        return merged;
    }

    @Override
    public Promise<HttpResponse> serve(HttpRequest request) throws Exception {
        Promise processed;
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        return (processed = this.tryServe(request)) != null ? processed : Promise.ofException((Exception)HttpError.notFound404());
    }

    @Nullable
    private Promise<HttpResponse> tryServe(HttpRequest request) throws Exception {
        AsyncServlet servlet;
        int ordinal;
        int introPosition = request.getPos();
        String urlPart = request.pollUrlPart();
        if (urlPart == null) {
            throw HttpError.badRequest400("Path contains bad percent encoding");
        }
        Protocol protocol = request.getProtocol();
        int n = ordinal = protocol == Protocol.WS || protocol == Protocol.WSS ? WS_ORDINAL : request.getMethod().ordinal();
        if (urlPart.isEmpty()) {
            servlet = RoutingServlet.getOrDefault(this.servlets, ordinal);
            if (servlet != null) {
                return servlet.serve(request);
            }
        } else {
            int position = request.getPos();
            RoutingServlet transit = this.routes.get(urlPart);
            if (transit != null) {
                Promise<HttpResponse> result = transit.tryServe(request);
                if (result != null) {
                    return result;
                }
                request.setPos(position);
            }
            for (Map.Entry<String, RoutingServlet> entry : this.parameters.entrySet()) {
                String key = entry.getKey();
                request.putPathParameter(key, urlPart);
                Promise<HttpResponse> result = entry.getValue().tryServe(request);
                if (result != null) {
                    return result;
                }
                request.removePathParameter(key);
                request.setPos(position);
            }
        }
        if ((servlet = RoutingServlet.getOrDefault(this.fallbackServlets, ordinal)) != null) {
            request.setPos(introPosition);
            return servlet.serve(request);
        }
        return null;
    }

    @Nullable
    public RoutingServlet getChild(String path) {
        return this.getChildImpl(path, (servlet, name) -> name.startsWith(":") ? servlet.parameters.get(name.substring(1)) : servlet.routes.get(name));
    }

    private RoutingServlet ensureChild(String path) {
        return this.getChildImpl(path, (servlet, name) -> name.startsWith(":") ? servlet.parameters.computeIfAbsent(name.substring(1), $ -> new RoutingServlet(this.reactor)) : servlet.routes.computeIfAbsent((String)name, $ -> new RoutingServlet(this.reactor)));
    }

    private RoutingServlet getChildImpl(String path, BiFunction<RoutingServlet, String, @Nullable RoutingServlet> childGetter) {
        if (path.isEmpty() || path.equals(ROOT)) {
            return this;
        }
        RoutingServlet sub = this;
        int slash = path.indexOf(47, 1);
        while (true) {
            String urlPart;
            if (!(urlPart = path.substring(1, slash == -1 ? path.length() : slash)).startsWith(":")) {
                urlPart = RoutingServlet.decodePattern(urlPart);
            }
            if (urlPart.isEmpty()) {
                return sub;
            }
            sub = childGetter.apply(sub, urlPart);
            if (slash == -1 || sub == null) {
                return sub;
            }
            path = path.substring(slash);
            slash = path.indexOf(47, 1);
        }
    }

    private static void mergeInto(RoutingServlet into, RoutingServlet from) {
        int i;
        for (i = 0; i < from.servlets.length; ++i) {
            AsyncServlet rootServlet = from.servlets[i];
            if (rootServlet == null) continue;
            RoutingServlet.set(into.servlets, i, rootServlet);
        }
        for (i = 0; i < from.fallbackServlets.length; ++i) {
            AsyncServlet fallbackServlet = from.fallbackServlets[i];
            if (fallbackServlet == null) continue;
            RoutingServlet.set(into.fallbackServlets, i, fallbackServlet);
        }
        from.routes.forEach((key, value) -> into.routes.merge((String)key, (RoutingServlet)value, (s1, s2) -> {
            RoutingServlet.mergeInto(s1, s2);
            return s1;
        }));
        from.parameters.forEach((key, value) -> into.parameters.merge((String)key, (RoutingServlet)value, (s1, s2) -> {
            RoutingServlet.mergeInto(s1, s2);
            return s1;
        }));
    }

    private static void set(AsyncServlet[] servlets, int ordinal, AsyncServlet servlet) {
        Checks.checkArgument((servlets[ordinal] == null ? 1 : 0) != 0, (Object)"Already mapped");
        servlets[ordinal] = servlet;
    }

    @Nullable
    private static AsyncServlet getOrDefault(AsyncServlet[] servlets, int ordinal) {
        AsyncServlet maybeResult = servlets[ordinal];
        if (maybeResult != null || ordinal == WS_ORDINAL) {
            return maybeResult;
        }
        return servlets[ANY_HTTP_ORDINAL];
    }

    private static String decodePattern(String pattern) {
        try {
            return URLDecoder.decode(pattern, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Pattern contains bad percent encoding", e);
        }
    }

    public class Builder
    extends AbstractBuilder<Builder, RoutingServlet> {
        public Builder with(String path, AsyncServlet servlet) {
            return this.with(null, path, servlet);
        }

        @Contract(value="_, _, _ -> this")
        public Builder with(@Nullable HttpMethod method, String path, AsyncServlet servlet) {
            Checks.checkNotNull((Object)path);
            Checks.checkNotNull((Object)servlet);
            return this.doMap(method == null ? ANY_HTTP_ORDINAL : method.ordinal(), path, servlet);
        }

        @Contract(value="_, _ -> this")
        public Builder withWebSocket(String path, final Consumer<IWebSocket> webSocketConsumer) {
            return this.withWebSocket(path, new WebSocketServlet(RoutingServlet.this.reactor){

                @Override
                protected void onWebSocket(IWebSocket webSocket) {
                    webSocketConsumer.accept(webSocket);
                }
            });
        }

        @Contract(value="_, _ -> this")
        public Builder withWebSocket(String path, WebSocketServlet servlet) {
            return this.doMap(WS_ORDINAL, path, servlet);
        }

        @Contract(value="_, _, _ -> this")
        private Builder doMap(int ordinal, String path, AsyncServlet servlet) {
            Checks.checkArgument((path.startsWith(RoutingServlet.ROOT) && (path.endsWith(RoutingServlet.WILDCARD) || !path.contains(RoutingServlet.STAR)) ? 1 : 0) != 0, (Object)("Invalid path: " + path));
            if (path.endsWith(RoutingServlet.WILDCARD)) {
                RoutingServlet routingServlet = RoutingServlet.this.ensureChild(path.substring(0, path.length() - 2));
                RoutingServlet.set(routingServlet.fallbackServlets, ordinal, servlet);
            } else {
                RoutingServlet.set(RoutingServlet.this.ensureChild((String)path).servlets, ordinal, servlet);
            }
            return this;
        }

        @Contract(value="_ -> new")
        public Builder merge(RoutingServlet servlet) {
            return this.merge(RoutingServlet.ROOT, servlet);
        }

        @Contract(value="_, _ -> new")
        public Builder merge(String path, RoutingServlet servlet) {
            RoutingServlet.mergeInto(RoutingServlet.this.ensureChild(path), servlet);
            return this;
        }

        protected RoutingServlet doBuild() {
            return RoutingServlet.this;
        }
    }
}

