/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.common.ApplicationSettings;
import io.activej.http.CaseInsensitiveTokenMap;
import io.activej.http.MediaType;
import java.util.HashMap;
import java.util.Map;

public final class MediaTypes {
    private static final int SLOTS_NUMBER = ApplicationSettings.getInt(MediaTypes.class, (String)"slotsNumber", (Integer)2048);
    private static final int MAX_PROBINGS = ApplicationSettings.getInt(MediaTypes.class, (String)"maxProbings", (Integer)2);
    private static final CaseInsensitiveTokenMap<MediaType> mimes = new CaseInsensitiveTokenMap<MediaType>(SLOTS_NUMBER, MAX_PROBINGS, MediaType::new, MediaType[]::new);
    private static final Map<String, MediaType> ext2mime = new HashMap<String, MediaType>();
    public static final MediaType ANY = MediaTypes.register("*/*", new String[0]);
    public static final MediaType ANY_APPLICATION = MediaTypes.register("application/*", new String[0]);
    public static final MediaType ANY_TEXT = MediaTypes.register("text/*", new String[0]);
    public static final MediaType ANY_IMAGE = MediaTypes.register("image/*", new String[0]);
    public static final MediaType ANY_AUDIO = MediaTypes.register("audio/*", new String[0]);
    public static final MediaType ANY_VIDEO = MediaTypes.register("video/*", new String[0]);
    public static final MediaType X_WWW_FORM_URLENCODED = MediaTypes.register("application/x-www-form-urlencoded", new String[0]);
    public static final MediaType ATOM = MediaTypes.register("application/atom+xml", "atom");
    public static final MediaType EDI_X12 = MediaTypes.register("application/EDI-X12", new String[0]);
    public static final MediaType EDI_EDIFACT = MediaTypes.register("application/EDIFACT", new String[0]);
    public static final MediaType JSON = MediaTypes.register("application/json", "json");
    public static final MediaType JAVASCRIPT = MediaTypes.register("application/javascript", "js");
    public static final MediaType OCTET_STREAM = MediaTypes.register("application/octet-stream", "com", "exe", "bin");
    public static final MediaType ZIP = MediaTypes.register("application/zip", "zip", "zipx");
    public static final MediaType GZIP = MediaTypes.register("application/gzip", "gzip", "gz");
    public static final MediaType BZIP2 = MediaTypes.register("application/x-bzip2", "bz2");
    public static final MediaType FLASH = MediaTypes.register("application/x-shockwave-flash", new String[0]);
    public static final MediaType TEX = MediaTypes.register("application/x-tex", new String[0]);
    public static final MediaType PDF = MediaTypes.register("application/pdf", "pdf");
    public static final MediaType OGG_APP = MediaTypes.register("application/ogg", "ogg");
    public static final MediaType POSTSCRIPT = MediaTypes.register("application/postscript", "ai");
    public static final MediaType BINARY = MediaTypes.register("application/binary", new String[0]);
    public static final MediaType TAR = MediaTypes.register("application/x-tar", "tar");
    public static final MediaType KEY_ARCHIVE = MediaTypes.register("application/pkcs12", "p12", "pfx");
    public static final MediaType PROTOBUF = MediaTypes.register("application/protobuf", "proto");
    public static final MediaType EPUB = MediaTypes.register("application/epub+zip", "epub");
    public static final MediaType RDF = MediaTypes.register("application/rdf+xml", "rdf");
    public static final MediaType XRD = MediaTypes.register("application/xrd+xml", "xrd");
    public static final MediaType JAVA_ARCHIVE = MediaTypes.register("application/java-archive", "jar", "war", "ear");
    public static final MediaType WOFF = MediaTypes.register("application/font-woff", "woff");
    public static final MediaType EOT = MediaTypes.register("application/vnd.ms-fontobject", "eot");
    public static final MediaType SFNT = MediaTypes.register("application/font-sfnt", "sfnt");
    public static final MediaType XML_APP = MediaTypes.register("application/xml", new String[0]);
    public static final MediaType XHTML_APP = MediaTypes.register("application/xhtml+xml", new String[0]);
    public static final MediaType CSS = MediaTypes.register("text/css", "css");
    public static final MediaType CSV = MediaTypes.register("text/csv", "csv");
    public static final MediaType HTML = MediaTypes.register("text/html", "html", "htm");
    public static final MediaType PLAIN_TEXT = MediaTypes.register("text/plain", "txt");
    public static final MediaType RTF = MediaTypes.register("text/rtf", "rtf");
    public static final MediaType XML = MediaTypes.register("text/xml", "xml");
    public static final MediaType XHTML = MediaTypes.register("text/xhtml+xml", "xhtml");
    public static final MediaType GV = MediaTypes.register("text/vnd.graphviz", "gv");
    public static final MediaType BMP = MediaTypes.register("image/bmp", "bmp");
    public static final MediaType ICO = MediaTypes.register("image/vnd.microsoft.icon", "ico");
    public static final MediaType CRW = MediaTypes.register("image/x-canon-crw", "crw");
    public static final MediaType PSD = MediaTypes.register("image/vnd.adobe.photoshop", "psd");
    public static final MediaType WEBP = MediaTypes.register("image/webp", "webp");
    public static final MediaType GIF = MediaTypes.register("image/gif", "gif");
    public static final MediaType JPEG = MediaTypes.register("image/jpeg", "jpeg", "jpg");
    public static final MediaType PNG = MediaTypes.register("image/png", "png");
    public static final MediaType SVG = MediaTypes.register("image/svg+xml", "svg");
    public static final MediaType TIFF = MediaTypes.register("image/tiff", "tiff", "tif");
    public static final MediaType OGG_AUDIO = MediaTypes.register("audio/ogg", "oga");
    public static final MediaType MP4_AUDIO = MediaTypes.register("audio/mp4", "mp4a");
    public static final MediaType MPEG_AUDIO = MediaTypes.register("audio/mpeg", "mpga");
    public static final MediaType WEBM_AUDIO = MediaTypes.register("audio/webm", "weba");
    public static final MediaType FLAC = MediaTypes.register("audio/x-flac", "flac");
    public static final MediaType MP3 = MediaTypes.register("audio/mp3", "mp3");
    public static final MediaType AAC = MediaTypes.register("audio/aac", "aac");
    public static final MediaType WMA = MediaTypes.register("audio/x-ms-wma", "wma");
    public static final MediaType REALAUDIO = MediaTypes.register("audio/vnd.rn-realaudio", "rm");
    public static final MediaType WAVE = MediaTypes.register("audio/vnd.wave", "wave", "wav");
    public static final MediaType MPEG = MediaTypes.register("video/mpeg", "mpeg", "mpg");
    public static final MediaType MP4 = MediaTypes.register("video/mp4", "mp4");
    public static final MediaType QUICKTIME = MediaTypes.register("video/quicktime", "mov", "moov", "qt", "qtvr");
    public static final MediaType OGG_VIDEO = MediaTypes.register("video/ogg", "ogv");
    public static final MediaType WEBM = MediaTypes.register("video/webm", "webm");
    public static final MediaType WMV = MediaTypes.register("video/x-ms-wmv", "wmv");
    public static final MediaType FLV = MediaTypes.register("video/x-flv", "flv");
    public static final MediaType AVI = MediaTypes.register("video/avi", "avi");

    static MediaType of(int hashCodeCI, byte[] bytes, int offset, int length) {
        return mimes.getOrCreate(hashCodeCI, bytes, offset, length);
    }

    static void render(MediaType mime, ByteBuf buf) {
        int len = MediaTypes.render(mime, buf.array(), buf.tail());
        buf.moveTail(len);
    }

    static int render(MediaType mime, byte[] container, int pos) {
        System.arraycopy(mime.bytes, mime.offset, container, pos, mime.length);
        return mime.length;
    }

    public static MediaType getByExtension(String ext) {
        return ext2mime.get(ext);
    }

    public static MediaType register(String name, String ... ext) {
        MediaType mime = mimes.register(name);
        MediaTypes.bindExts2mime(mime, ext);
        return mime;
    }

    private static void bindExts2mime(MediaType mime, String ... exts) {
        for (String ext : exts) {
            ext2mime.put(ext, mime);
        }
    }
}

