/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.process.AsyncCloseable;
import io.activej.bytebuf.ByteBuf;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.recycle.Recyclable;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.csp.consumer.ChannelConsumers;
import io.activej.csp.supplier.ChannelSupplier;
import io.activej.csp.supplier.ChannelSuppliers;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.promise.Promise;
import org.jetbrains.annotations.Nullable;

public interface IWebSocket
extends AsyncCloseable {
    public static final boolean ENABLED = ApplicationSettings.getBoolean(IWebSocket.class, (String)"enabled", (Boolean)true);

    public Promise<Message> readMessage();

    public Promise<Frame> readFrame();

    default public ChannelSupplier<Frame> frameReadChannel() {
        return ChannelSuppliers.ofAsyncSupplier(this::readFrame, (AsyncCloseable)this);
    }

    default public ChannelSupplier<Message> messageReadChannel() {
        return ChannelSuppliers.ofAsyncSupplier(this::readMessage, (AsyncCloseable)this);
    }

    public Promise<Void> writeMessage(@Nullable Message var1);

    public Promise<Void> writeFrame(@Nullable Frame var1);

    default public ChannelConsumer<Frame> frameWriteChannel() {
        return ChannelConsumers.ofAsyncConsumer(this::writeFrame, (AsyncCloseable)this).withAcknowledgement(ack -> ack.then(() -> this.writeFrame(null)));
    }

    default public ChannelConsumer<Message> messageWriteChannel() {
        return ChannelConsumers.ofAsyncConsumer(this::writeMessage, (AsyncCloseable)this).withAcknowledgement(ack -> ack.then(() -> this.writeMessage(null)));
    }

    public HttpRequest getRequest();

    public HttpResponse getResponse();

    public boolean isClosed();

    public static final class Message
    implements Recyclable {
        private final MessageType type;
        @Nullable
        private final ByteBuf binaryPayload;
        @Nullable
        private final String textPayload;

        Message(MessageType type, @Nullable ByteBuf binaryPayload, @Nullable String textPayload) {
            this.type = type;
            this.textPayload = textPayload;
            this.binaryPayload = binaryPayload;
        }

        public static Message text(String payload) {
            return new Message(MessageType.TEXT, null, payload);
        }

        public static Message binary(ByteBuf payload) {
            return new Message(MessageType.BINARY, payload, null);
        }

        public MessageType getType() {
            return this.type;
        }

        public ByteBuf getBuf() {
            return (ByteBuf)Checks.checkNotNull((Object)this.binaryPayload);
        }

        public String getText() {
            return (String)Checks.checkNotNull((Object)this.textPayload);
        }

        public void recycle() {
            if (this.binaryPayload != null) {
                this.binaryPayload.recycle();
            }
        }

        public static enum MessageType {
            TEXT,
            BINARY;

        }
    }

    public static final class Frame
    implements Recyclable {
        private final FrameType type;
        private final ByteBuf payload;
        private final boolean isLastFrame;

        Frame(FrameType type, ByteBuf payload, boolean isLastFrame) {
            this.type = type;
            this.payload = payload;
            this.isLastFrame = isLastFrame;
        }

        public static Frame text(ByteBuf buf) {
            return new Frame(FrameType.TEXT, buf, true);
        }

        public static Frame text(ByteBuf buf, boolean isLastFrame) {
            return new Frame(FrameType.TEXT, buf, isLastFrame);
        }

        public static Frame binary(ByteBuf buf) {
            return new Frame(FrameType.BINARY, buf, true);
        }

        public static Frame binary(ByteBuf buf, boolean isLastFrame) {
            return new Frame(FrameType.BINARY, buf, isLastFrame);
        }

        public static Frame next(ByteBuf buf, boolean isLastFrame) {
            return new Frame(FrameType.CONTINUATION, buf, isLastFrame);
        }

        public FrameType getType() {
            return this.type;
        }

        public ByteBuf getPayload() {
            return this.payload;
        }

        public boolean isLastFrame() {
            return this.isLastFrame;
        }

        public void recycle() {
            this.payload.recycle();
        }

        public static enum FrameType {
            TEXT,
            BINARY,
            CONTINUATION;

        }
    }
}

