/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.Utils;
import io.activej.common.initializer.WithInitializer;
import io.activej.csp.ChannelInput;
import io.activej.csp.consumer.ChannelConsumers;
import io.activej.csp.supplier.ChannelSupplier;
import io.activej.csp.supplier.ChannelSuppliers;
import io.activej.http.HttpCookie;
import io.activej.http.HttpHeader;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaderValueBiPredicate;
import io.activej.http.HttpHeaderValuePredicate;
import io.activej.http.HttpHeadersMultimap;
import io.activej.http.HttpUtils;
import io.activej.http.HttpVersion;
import io.activej.http.MalformedHttpException;
import io.activej.http.stream.BufsConsumerGzipInflater;
import io.activej.promise.Promise;
import io.activej.promise.ToPromise;
import io.activej.types.TypeT;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class HttpMessage {
    private static final boolean CHECKS = Checks.isEnabled(HttpMessage.class);
    static final byte MUST_LOAD_BODY = 1;
    static final byte USE_GZIP = 2;
    static final byte BODY_STREAM_GZIPPED = 4;
    static final byte RECYCLED = -128;
    private final HttpVersion version;
    byte flags;
    final HttpHeadersMultimap headers = new HttpHeadersMultimap();
    @Nullable
    ByteBuf body;
    @Nullable
    ChannelSupplier<ByteBuf> bodyStream;
    protected int maxBodySize;
    protected Map<Object, Object> attachments;

    protected HttpMessage(HttpVersion version) {
        this.version = version;
    }

    public HttpVersion getVersion() {
        return this.version;
    }

    public Collection<Map.Entry<HttpHeader, HttpHeaderValue>> getHeaders() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.headers.getEntries();
    }

    public <T> List<T> getHeader(HttpHeader header, HttpHeaderValue.DecoderInToListStreamConsumer<T> decoder) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        ArrayList list = new ArrayList();
        this.headers.forEach(header, httpHeaderValue -> {
            decoder.decode(httpHeaderValue.getBuf(), list);
            return true;
        });
        return list;
    }

    public boolean hasHeader(HttpHeader header) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.headers.get(header) != null;
    }

    @Nullable
    public <T> T getHeader(HttpHeader header, HttpDecoderFunction<T> decoder) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        try {
            ByteBuf buf = this.getHeaderBuf(header);
            if (buf != null) {
                return decoder.decode(buf);
            }
        }
        catch (MalformedHttpException malformedHttpException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public String getHeader(HttpHeader header) {
        HttpHeaderValue headerValue;
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return (headerValue = this.headers.get(header)) != null ? headerValue.toString() : null;
    }

    @Nullable
    public ByteBuf getHeaderBuf(HttpHeader header) {
        HttpHeaderValue headerBuf;
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return (headerBuf = this.headers.get(header)) != null ? headerBuf.getBuf() : null;
    }

    public <T> void forEachHeader(HttpHeaderValueBiPredicate predicate) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.headers.forEach(predicate);
    }

    public <T> void forEachHeader(HttpHeader header, HttpHeaderValuePredicate predicate) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.headers.forEach(header, predicate);
    }

    public ChannelSupplier<ByteBuf> takeBodyStream() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        ChannelSupplier<ByteBuf> bodyStream = this.bodyStream;
        this.bodyStream = null;
        if (bodyStream != null) {
            return (this.flags & 4) == 0 ? bodyStream : HttpMessage.decodeGzip(bodyStream);
        }
        if (this.body != null) {
            ByteBuf body = this.body;
            this.body = null;
            return ChannelSuppliers.ofValue((Object)body);
        }
        throw new IllegalStateException("Body stream is missing or already consumed");
    }

    public ByteBuf getBody() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if ((this.flags & 1) != 0) {
            throw new IllegalStateException("Body is not loaded");
        }
        if (this.body != null) {
            return this.body;
        }
        throw new IllegalStateException("Body is missing or already consumed");
    }

    public ByteBuf takeBody() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        ByteBuf body = this.getBody();
        this.body = null;
        return body;
    }

    public boolean hasBody() {
        return (this.flags & 1) == 0 && this.body != null;
    }

    public Promise<ByteBuf> loadBody() {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.loadBody(this.maxBodySize);
    }

    public Promise<ByteBuf> loadBody(MemSize maxBodySize) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.loadBody(maxBodySize.toInt());
    }

    public Promise<ByteBuf> loadBody(int maxBodySize) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.body != null) {
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            return Promise.of((Object)this.body);
        }
        ChannelSupplier<ByteBuf> bodyStream = this.bodyStream;
        if (bodyStream == null) {
            throw new IllegalStateException("Body stream is missing or already consumed");
        }
        this.bodyStream = null;
        if ((this.flags & 4) != 0) {
            bodyStream = HttpMessage.decodeGzip(bodyStream);
        }
        return ChannelSupplier.collect(bodyStream, (Object)new ByteBufs(), (bufs, buf) -> {
            if (maxBodySize != 0 && bufs.hasRemainingBytes(maxBodySize)) {
                bufs.recycle();
                buf.recycle();
                throw new MalformedHttpException("HTTP body size exceeds load limit " + maxBodySize);
            }
            bufs.add(buf);
        }, ByteBufs::takeRemaining).whenResult(body -> {
            assert (!this.isRecycled());
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            this.body = body;
        });
    }

    public Map<Object, Object> ensureAttachments() {
        if (this.attachments == null) {
            this.attachments = new HashMap<Object, Object>();
        }
        return this.attachments;
    }

    public <T> void attach(Type type, T extra) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.ensureAttachments().put(type, extra);
    }

    public <T> void attach(Class<T> type, T extra) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.ensureAttachments().put(type, extra);
    }

    public <T> void attach(TypeT<T> typeT, T extra) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.ensureAttachments().put(typeT.getAnnotatedType(), extra);
    }

    public void attach(Object extra) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.ensureAttachments().put(extra.getClass(), extra);
    }

    public <T> void attach(String key, T extra) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.ensureAttachments().put(key, extra);
    }

    public <T> T getAttachment(Class<T> type) {
        if (this.attachments == null) {
            return null;
        }
        Object res = this.attachments.get(type);
        return (T)res;
    }

    public <T> T getAttachment(TypeT<T> typeT) {
        if (this.attachments == null) {
            return null;
        }
        Object res = this.attachments.get(typeT.getAnnotatedType());
        return (T)res;
    }

    public <T> T getAttachment(Type type) {
        if (this.attachments == null) {
            return null;
        }
        Object res = this.attachments.get(type);
        return (T)res;
    }

    public <T> T getAttachment(String key) {
        if (this.attachments == null) {
            return null;
        }
        Object res = this.attachments.get(key);
        return (T)res;
    }

    public Set<Object> getAttachmentKeys() {
        return this.attachments != null ? this.attachments.keySet() : Set.of();
    }

    public boolean isRecycled() {
        return (this.flags & 0xFFFFFF80) != 0;
    }

    abstract boolean isContentLengthExpected();

    void recycle() {
        if (this.isRecycled()) {
            return;
        }
        this.flags = (byte)(this.flags | 0xFFFFFF80);
        if (this.body != null) {
            this.body.recycle();
        }
        if (this.bodyStream != null) {
            this.bodyStream.streamTo(ChannelConsumers.recycling());
        }
    }

    void recycleBody() {
        this.body = (ByteBuf)Utils.nullify((Object)this.body, ByteBuf::recycle);
        this.bodyStream = (ChannelSupplier)Utils.nullify(this.bodyStream, stream -> stream.streamTo(ChannelConsumers.recycling()));
    }

    protected void writeHeaders(ByteBuf buf) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        byte[] array = buf.array();
        int offset = buf.tail();
        for (int i = 0; i < this.headers.kvPairs.length - 1; i += 2) {
            HttpHeader k = (HttpHeader)this.headers.kvPairs[i];
            if (k == null) continue;
            HttpHeaderValue v = (HttpHeaderValue)this.headers.kvPairs[i + 1];
            array[offset++] = 13;
            array[offset++] = 10;
            offset = k.writeTo(array, offset);
            array[offset++] = 58;
            array[offset++] = 32;
            offset = v.writeTo(array, offset);
        }
        array[offset++] = 13;
        array[offset++] = 10;
        array[offset++] = 13;
        array[offset++] = 10;
        buf.tail(offset);
    }

    protected int estimateSize(int firstLineSize) {
        if (CHECKS) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        int size = firstLineSize;
        for (int i = 0; i < this.headers.kvPairs.length - 1; i += 2) {
            HttpHeader k = (HttpHeader)this.headers.kvPairs[i];
            if (k == null) continue;
            HttpHeaderValue v = (HttpHeaderValue)this.headers.kvPairs[i + 1];
            size += 2 + k.size() + 2 + v.estimateSize();
        }
        return size += 4;
    }

    protected abstract int estimateSize();

    protected abstract void writeTo(ByteBuf var1);

    private static ChannelSupplier<ByteBuf> decodeGzip(ChannelSupplier<ByteBuf> bodyStream) {
        BufsConsumerGzipInflater decoder = BufsConsumerGzipInflater.create();
        bodyStream.bindTo((ChannelInput)decoder.getInput());
        return decoder.getOutput().getSupplier().withEndOfStream(eos -> eos.mapException(HttpUtils::translateToHttpException));
    }

    public static interface HttpDecoderFunction<T> {
        public T decode(ByteBuf var1) throws MalformedHttpException;
    }

    protected abstract class Builder<B extends Builder<B, T>, T extends HttpMessage>
    implements io.activej.common.builder.Builder<T>,
    ToPromise<T>,
    WithInitializer<B> {
        protected Builder() {
        }

        public B withHeader(HttpHeader header, String string) {
            HttpHeaderValue headerValue = HttpHeaderValue.of(string);
            HttpMessage.this.headers.add(header, headerValue);
            return (B)this;
        }

        public B withHeader(HttpHeader header, byte[] value) {
            HttpHeaderValue headerValue = HttpHeaderValue.ofBytes(value, 0, value.length);
            HttpMessage.this.headers.add(header, headerValue);
            return (B)this;
        }

        public B withHeader(HttpHeader header, byte[] array, int off, int len) {
            HttpHeaderValue headerValue = HttpHeaderValue.ofBytes(array, off, len);
            HttpMessage.this.headers.add(header, headerValue);
            return (B)this;
        }

        public B withHeader(HttpHeader header, HttpHeaderValue value) {
            HttpMessage.this.headers.add(header, value);
            return (B)this;
        }

        public B withCookies(HttpCookie ... cookies) {
            this.addCookies(List.of(cookies));
            return (B)this;
        }

        public B withCookies(List<HttpCookie> cookies) {
            this.addCookies(cookies);
            return (B)this;
        }

        public B withCookie(HttpCookie cookie) {
            this.addCookie(cookie);
            return (B)this;
        }

        protected abstract void addCookies(List<HttpCookie> var1);

        protected abstract void addCookie(HttpCookie var1);

        public B withBodyStream(ChannelSupplier<ByteBuf> bodySupplier) {
            HttpMessage.this.bodyStream = bodySupplier;
            return (B)this;
        }

        public B withBody(ByteBuf body) {
            HttpMessage.this.body = body;
            return (B)this;
        }

        public B withBody(byte[] body) {
            return this.withBody(ByteBuf.wrapForReading((byte[])body));
        }

        public B withBody(String string) {
            return this.withBody(string, StandardCharsets.UTF_8);
        }

        public B withBody(String string, Charset charset) {
            return this.withBody(string.getBytes(charset));
        }

        public B withMaxBodySize(MemSize maxBodySize) {
            HttpMessage.this.maxBodySize = maxBodySize.toInt();
            return (B)this;
        }

        public B withMaxBodySize(int maxBodySize) {
            HttpMessage.this.maxBodySize = maxBodySize;
            return (B)this;
        }

        public B withBodyGzipCompression() {
            HttpMessage.this.flags = (byte)(HttpMessage.this.flags | 2);
            return (B)this;
        }

        public Promise<T> toPromise() {
            return Promise.of((Object)this.build());
        }

        public T build() {
            return (T)HttpMessage.this;
        }
    }
}

