/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.ApplicationSettings;
import io.activej.http.HttpHeader;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaderValueBiPredicate;
import io.activej.http.HttpHeaderValuePredicate;
import io.activej.http.MalformedHttpException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HttpHeadersMultimap {
    static final int INITIAL_SIZE = ApplicationSettings.getInt(HttpHeadersMultimap.class, (String)"initialSize", (Integer)4);
    Object[] kvPairs;
    int size;

    public HttpHeadersMultimap(int initialSize) {
        this.kvPairs = new Object[1 << 32 - Integer.numberOfLeadingZeros(initialSize - 1) + 1];
    }

    public HttpHeadersMultimap() {
        this(INITIAL_SIZE);
    }

    @Contract(pure=true)
    public int size() {
        return this.size;
    }

    public void add(HttpHeader key, HttpHeaderValue value) {
        if (this.size++ > this.kvPairs.length / 4) {
            this.resize();
        }
        int i = key.hashCode() & this.kvPairs.length - 2;
        while (true) {
            if (this.kvPairs[i] == null) {
                this.kvPairs[i] = key;
                this.kvPairs[i + 1] = value;
                return;
            }
            i = i + 2 & this.kvPairs.length - 2;
        }
    }

    public void addIfAbsent(HttpHeader key, HttpHeaderValue value) {
        HttpHeaderValue existing = this.get(key);
        if (existing != null) {
            return;
        }
        this.add(key, value);
    }

    public void addIfAbsent(HttpHeader key, Supplier<HttpHeaderValue> valueSupplier) {
        HttpHeaderValue existing = this.get(key);
        if (existing != null) {
            return;
        }
        this.add(key, valueSupplier.get());
    }

    private void resize() {
        int beforeResize = this.size;
        Object[] oldKvPairs = this.kvPairs;
        this.kvPairs = new Object[this.kvPairs.length * 4];
        for (int i = 0; i != oldKvPairs.length; i += 2) {
            HttpHeader k = (HttpHeader)oldKvPairs[i];
            if (k == null) continue;
            HttpHeaderValue v = (HttpHeaderValue)oldKvPairs[i + 1];
            this.add(k, v);
        }
        this.size = beforeResize;
    }

    @Contract(pure=true)
    @Nullable
    public HttpHeaderValue get(HttpHeader key) {
        Object[] kvPairs = this.kvPairs;
        int i = key.hashCode() & kvPairs.length - 2;
        HttpHeader k;
        while ((k = (HttpHeader)kvPairs[i]) != null) {
            if (k.equals(key)) {
                return (HttpHeaderValue)kvPairs[i + 1];
            }
            i = i + 2 & kvPairs.length - 2;
        }
        return null;
    }

    public Collection<Map.Entry<HttpHeader, HttpHeaderValue>> getEntries() {
        return new AbstractCollection<Map.Entry<HttpHeader, HttpHeaderValue>>(){

            @Override
            public int size() {
                return HttpHeadersMultimap.this.size;
            }

            @Override
            @NotNull
            public Iterator<Map.Entry<HttpHeader, HttpHeaderValue>> iterator() {
                return new Iterator<Map.Entry<HttpHeader, HttpHeaderValue>>(){
                    int i = 0;
                    @Nullable
                    HttpHeader k;
                    @Nullable
                    HttpHeaderValue v;
                    {
                        this.advance();
                    }

                    private void advance() {
                        while (this.i < HttpHeadersMultimap.this.kvPairs.length) {
                            HttpHeader k = (HttpHeader)HttpHeadersMultimap.this.kvPairs[this.i];
                            if (k != null) {
                                this.k = k;
                                this.v = (HttpHeaderValue)HttpHeadersMultimap.this.kvPairs[this.i + 1];
                                this.i += 2;
                                return;
                            }
                            this.i += 2;
                        }
                        this.k = null;
                        this.v = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.k != null;
                    }

                    @Override
                    public Map.Entry<HttpHeader, HttpHeaderValue> next() {
                        if (this.k == null) {
                            throw new NoSuchElementException();
                        }
                        AbstractMap.SimpleImmutableEntry<HttpHeader, HttpHeaderValue> entry = new AbstractMap.SimpleImmutableEntry<HttpHeader, HttpHeaderValue>(this.k, this.v);
                        this.advance();
                        return entry;
                    }
                };
            }
        };
    }

    public void forEach(HttpHeaderValueBiPredicate predicate) {
        Object[] kvPairs = this.kvPairs;
        for (int i = 0; i < kvPairs.length - 1; i += 2) {
            HttpHeader k = (HttpHeader)kvPairs[i];
            if (k == null) continue;
            try {
                if (predicate.test(k, (HttpHeaderValue)kvPairs[i + 1])) continue;
                break;
            }
            catch (MalformedHttpException malformedHttpException) {
                // empty catch block
            }
        }
    }

    public void forEach(HttpHeader header, HttpHeaderValuePredicate predicate) {
        HttpHeader k;
        Object[] kvPairs = this.kvPairs;
        int i = header.hashCode() & kvPairs.length - 2;
        while ((k = (HttpHeader)kvPairs[i]) != null) {
            if (k.equals(header)) {
                try {
                    if (!predicate.test((HttpHeaderValue)kvPairs[i + 1])) {
                        break;
                    }
                }
                catch (MalformedHttpException malformedHttpException) {
                    // empty catch block
                }
            }
            i = i + 2 & kvPairs.length - 2;
        }
    }

    public String toString() {
        return Arrays.toString(this.kvPairs);
    }
}

