/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.callback.Callback;
import io.activej.async.exception.AsyncCloseException;
import io.activej.async.exception.AsyncTimeoutException;
import io.activej.async.service.ReactiveService;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.builder.AbstractBuilder;
import io.activej.common.inspector.AbstractInspector;
import io.activej.common.inspector.BaseInspector;
import io.activej.dns.IDnsClient;
import io.activej.dns.protocol.DnsQueryException;
import io.activej.dns.protocol.DnsResponse;
import io.activej.http.AbstractHttpConnection;
import io.activej.http.AddressLinkedList;
import io.activej.http.ConnectionsLinkedList;
import io.activej.http.HttpClientConnection;
import io.activej.http.HttpException;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.HttpUtils;
import io.activej.http.IHttpClient;
import io.activej.http.IWebSocket;
import io.activej.http.IWebSocketClient;
import io.activej.http.MalformedHttpException;
import io.activej.http.PoolLabel;
import io.activej.http.Protocol;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxOperation;
import io.activej.jmx.api.attribute.JmxReducers;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.ExceptionStats;
import io.activej.jmx.stats.MBeanFormat;
import io.activej.net.socket.tcp.ITcpSocket;
import io.activej.net.socket.tcp.SslTcpSocket;
import io.activej.net.socket.tcp.TcpSocket;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import io.activej.reactor.AbstractNioReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import io.activej.reactor.jmx.ReactiveJmxBeanWithStats;
import io.activej.reactor.net.SocketSettings;
import io.activej.reactor.nio.NioReactor;
import io.activej.reactor.schedule.ScheduledRunnable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClient
extends AbstractNioReactive
implements IHttpClient,
IWebSocketClient,
ReactiveService,
ReactiveJmxBeanWithStats {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private static final boolean CHECKS = Checks.isEnabled(HttpClient.class);
    public static final Duration CONNECT_TIMEOUT = ApplicationSettings.getDuration(HttpClient.class, (String)"connectTimeout", (Duration)Duration.ZERO);
    public static final Duration READ_WRITE_TIMEOUT = ApplicationSettings.getDuration(HttpClient.class, (String)"readWriteTimeout", (Duration)Duration.ZERO);
    public static final Duration READ_WRITE_TIMEOUT_SHUTDOWN = ApplicationSettings.getDuration(HttpClient.class, (String)"readWriteTimeout_Shutdown", (Duration)Duration.ofSeconds(3L));
    public static final Duration KEEP_ALIVE_TIMEOUT = ApplicationSettings.getDuration(HttpClient.class, (String)"keepAliveTimeout", (Duration)Duration.ZERO);
    public static final MemSize MAX_BODY_SIZE = ApplicationSettings.getMemSize(HttpClient.class, (String)"maxBodySize", (MemSize)MemSize.ZERO);
    public static final MemSize MAX_WEB_SOCKET_MESSAGE_SIZE = ApplicationSettings.getMemSize(HttpClient.class, (String)"maxWebSocketMessageSize", (MemSize)MemSize.megabytes((long)1L));
    public static final int MAX_KEEP_ALIVE_REQUESTS = ApplicationSettings.getInt(HttpClient.class, (String)"maxKeepAliveRequests", (Integer)0);
    public static final HttpHeaderValue UPGRADE_HEADER = HttpHeaderValue.ofBytes(ByteBufStrings.encodeAscii((String)"Upgrade"));
    public static final HttpHeaderValue WEBSOCKET_HEADER = HttpHeaderValue.ofBytes(ByteBufStrings.encodeAscii((String)"Websocket"));
    public static final HttpHeaderValue WEBSOCKET_VERSION_HEADER = HttpHeaderValue.ofBytes(AbstractHttpConnection.WEB_SOCKET_VERSION);
    private final IDnsClient dnsClient;
    private SocketSettings socketSettings = SocketSettings.defaultInstance();
    final HashMap<InetSocketAddress, AddressLinkedList> addresses = new HashMap();
    final ConnectionsLinkedList poolKeepAlive = new ConnectionsLinkedList();
    final ConnectionsLinkedList poolReadWrite = new ConnectionsLinkedList();
    private int poolKeepAliveExpired;
    private int poolReadWriteExpired;
    @Nullable
    private ScheduledRunnable expiredConnectionsCheck;
    int connectTimeoutMillis = (int)CONNECT_TIMEOUT.toMillis();
    int readWriteTimeoutMillis = (int)READ_WRITE_TIMEOUT.toMillis();
    int readWriteTimeoutMillisShutdown = (int)READ_WRITE_TIMEOUT_SHUTDOWN.toMillis();
    int keepAliveTimeoutMillis = (int)KEEP_ALIVE_TIMEOUT.toMillis();
    int maxBodySize = MAX_BODY_SIZE.toInt();
    int maxWebSocketMessageSize = MAX_WEB_SOCKET_MESSAGE_SIZE.toInt();
    int maxKeepAliveRequests = MAX_KEEP_ALIVE_REQUESTS;
    private SSLContext sslContext;
    private Executor sslExecutor;
    @Nullable
    private TcpSocket.Inspector socketInspector;
    @Nullable
    private TcpSocket.Inspector socketSslInspector;
    @Nullable
    Inspector inspector;
    private int pendingResolves;
    private int pendingConnects;
    private boolean forcedShutdown;
    @Nullable
    SettablePromise<Void> shutdownPromise;
    private int inetAddressIdx = 0;

    private HttpClient(NioReactor reactor, IDnsClient dnsClient) {
        super(reactor);
        this.dnsClient = dnsClient;
    }

    public static HttpClient create(NioReactor reactor, IDnsClient dnsClient) {
        return (HttpClient)HttpClient.builder(reactor, dnsClient).build();
    }

    public static Builder builder(NioReactor reactor, IDnsClient dnsClient) {
        return new HttpClient(reactor, dnsClient).new Builder();
    }

    private void scheduleExpiredConnectionsCheck() {
        assert (this.expiredConnectionsCheck == null);
        this.expiredConnectionsCheck = this.reactor.delayBackground(1000L, () -> {
            boolean isClosing;
            this.expiredConnectionsCheck = null;
            this.poolKeepAliveExpired += this.poolKeepAlive.closeExpiredConnections(this.reactor.currentTimeMillis() - (long)this.keepAliveTimeoutMillis);
            boolean bl = isClosing = this.shutdownPromise != null;
            if (this.readWriteTimeoutMillis != 0 || isClosing) {
                this.poolReadWriteExpired += this.poolReadWrite.closeExpiredConnections(this.reactor.currentTimeMillis() - (long)(!isClosing ? this.readWriteTimeoutMillis : this.readWriteTimeoutMillisShutdown), new AsyncTimeoutException("Read timeout"));
            }
            if (this.getConnectionsCount() != 0) {
                this.scheduleExpiredConnectionsCheck();
                if (isClosing) {
                    logger.info("...Waiting for {}", (Object)this);
                }
            }
        });
    }

    @Nullable
    private HttpClientConnection takeKeepAliveConnection(InetSocketAddress address) {
        AddressLinkedList addresses = this.addresses.get(address);
        if (addresses == null) {
            return null;
        }
        HttpClientConnection connection = addresses.removeLastNode();
        assert (connection != null);
        assert (connection.pool == this.poolKeepAlive);
        assert (connection.remoteAddress.equals(address));
        connection.pool.removeNode(connection);
        if (addresses.isEmpty()) {
            this.addresses.remove(address);
        }
        return connection;
    }

    void returnToKeepAlivePool(HttpClientConnection connection) {
        assert (!connection.isClosed());
        AddressLinkedList addresses = this.addresses.computeIfAbsent(connection.remoteAddress, k -> new AddressLinkedList());
        addresses.addLastNode(connection);
        connection.switchPool(this.poolKeepAlive);
        if (this.expiredConnectionsCheck == null) {
            this.scheduleExpiredConnectionsCheck();
        }
    }

    @Override
    public Promise<HttpResponse> request(HttpRequest request) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
            Checks.checkArgument((Object)((Object)request.getProtocol()), protocol -> protocol == Protocol.HTTP || protocol == Protocol.HTTPS);
        }
        return this.doRequest(request, false);
    }

    @Override
    public Promise<IWebSocket> webSocketRequest(HttpRequest request) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        Checks.checkState((boolean)IWebSocket.ENABLED, (Object)"Web sockets are disabled by application settings");
        Checks.checkArgument((request.getProtocol() == Protocol.WS || request.getProtocol() == Protocol.WSS ? 1 : 0) != 0, (Object)"Wrong protocol");
        Checks.checkArgument((request.body == null && request.bodyStream == null ? 1 : 0) != 0, (Object)"No body should be present");
        request.headers.addIfAbsent(HttpHeaders.CONNECTION, UPGRADE_HEADER);
        request.headers.addIfAbsent(HttpHeaders.UPGRADE, WEBSOCKET_HEADER);
        request.headers.addIfAbsent(HttpHeaders.SEC_WEBSOCKET_VERSION, WEBSOCKET_VERSION_HEADER);
        return this.doRequest(request, true);
    }

    private Promise<?> doRequest(HttpRequest request, boolean isWebSocket) {
        int colonIndex;
        assert (this.reactor.inReactorThread());
        String hostAndPort = request.getHeader(HttpHeaders.HOST);
        if (hostAndPort == null) {
            hostAndPort = request.getUrl().getHostAndPort();
            assert (hostAndPort != null);
            request.headers.add(HttpHeaders.HOST, HttpHeaderValue.of(hostAndPort));
        }
        if (this.inspector != null) {
            this.inspector.onRequest(request);
        }
        String host = (colonIndex = hostAndPort.lastIndexOf(58)) == -1 ? hostAndPort : hostAndPort.substring(0, colonIndex);
        ++this.pendingResolves;
        return this.dnsClient.resolve4(host).then((v, e) -> this.handleShutdown((Object)v, (Exception)e, --this.pendingResolves)).thenCallback((dnsResponse, cb) -> {
            if (this.inspector != null) {
                this.inspector.onResolve(request, (DnsResponse)dnsResponse);
            }
            if (!dnsResponse.isSuccessful()) {
                request.recycleBody();
                cb.setException((Exception)new HttpException(new DnsQueryException((DnsResponse)dnsResponse)));
                return;
            }
            this.doSend(request, dnsResponse.getRecord().getIps(), isWebSocket).subscribe((Callback)cb);
        }, (e, cb) -> {
            if (this.inspector != null) {
                this.inspector.onResolveError(request, (Exception)e);
            }
            request.recycleBody();
            cb.setException(HttpUtils.translateToHttpException(e));
        });
    }

    private Promise<?> doSend(HttpRequest request, InetAddress[] inetAddresses, boolean isWebSocket) {
        InetAddress inetAddress;
        InetSocketAddress address;
        HttpClientConnection keepAliveConnection;
        if ((keepAliveConnection = this.takeKeepAliveConnection(address = new InetSocketAddress(inetAddress = inetAddresses[(this.inetAddressIdx++ & Integer.MAX_VALUE) % inetAddresses.length], request.getUrl().getPort()))) != null) {
            if (isWebSocket) {
                return keepAliveConnection.sendWebSocketRequest(request);
            }
            return keepAliveConnection.send(request);
        }
        boolean isSecure = request.getProtocol().isSecure();
        if (isSecure && this.sslContext == null) {
            request.recycleBody();
            throw new IllegalArgumentException("Cannot send Secure Request without SSL enabled");
        }
        if (this.inspector != null) {
            this.inspector.onConnecting(request, address);
        }
        ++this.pendingConnects;
        return TcpSocket.connect((NioReactor)this.reactor, (InetSocketAddress)address, (long)this.connectTimeoutMillis, (SocketSettings)this.socketSettings).then((v, e) -> this.handleShutdown((Object)v, (Exception)e, --this.pendingConnects)).then(tcpSocket -> {
            TcpSocket.Inspector socketInspector;
            TcpSocket.Inspector inspector = socketInspector = isSecure ? this.socketInspector : this.socketSslInspector;
            if (socketInspector != null) {
                socketInspector.onConnect(tcpSocket);
                tcpSocket.setInspector(socketInspector);
            }
            String host = request.getUrl().getHost();
            assert (host != null);
            TcpSocket socket = isSecure ? SslTcpSocket.wrapClientSocket((NioReactor)this.reactor, (ITcpSocket)tcpSocket, (String)host, (int)request.getUrl().getPort(), (SSLContext)this.sslContext, (Executor)this.sslExecutor) : tcpSocket;
            HttpClientConnection connection = new HttpClientConnection((Reactor)this.reactor, this, (ITcpSocket)socket, address);
            if (this.inspector != null) {
                this.inspector.onConnect(request, connection);
            }
            if (this.expiredConnectionsCheck == null) {
                this.scheduleExpiredConnectionsCheck();
            }
            if (isWebSocket) {
                return connection.sendWebSocketRequest(request).cast();
            }
            return connection.send(request).cast();
        }, e -> {
            if (this.inspector != null) {
                this.inspector.onConnectError(request, address, (Exception)e);
            }
            request.recycleBody();
            return Promise.ofException((Exception)HttpUtils.translateToHttpException(e));
        });
    }

    private <T> Promise<T> handleShutdown(T value, Exception e, int countdown) {
        if (this.shutdownPromise != null) {
            if (countdown == 0) {
                this.handleShutdown();
            }
            if (e == null && this.forcedShutdown) {
                return Promise.ofException((Exception)new AsyncCloseException("Connection closed"));
            }
        }
        return Promise.of(value, (Exception)e);
    }

    void handleShutdown() {
        if (this.shutdownPromise != null && this.pendingResolves == 0 && this.pendingConnects == 0 && this.getConnectionsCount() == 0) {
            SettablePromise<Void> shutdownPromise = this.shutdownPromise;
            this.reactor.post(() -> shutdownPromise.set(null));
            this.shutdownPromise = null;
        }
    }

    public Promise<?> start() {
        Reactive.checkInReactorThread((Reactive)this);
        return Promise.complete();
    }

    public Promise<?> stop() {
        Reactive.checkInReactorThread((Reactive)this);
        SettablePromise promise = new SettablePromise();
        this.poolKeepAlive.closeAllConnections();
        if (this.forcedShutdown) {
            this.poolReadWrite.closeAllConnections();
        }
        assert (this.addresses.isEmpty());
        this.keepAliveTimeoutMillis = 0;
        if (this.pendingResolves == 0 && this.pendingConnects == 0 && this.getConnectionsCount() == 0) {
            assert (this.poolReadWrite.isEmpty());
            promise.set(null);
        } else {
            this.shutdownPromise = promise;
            logger.info("Waiting for {}", (Object)this);
        }
        return promise;
    }

    @JmxAttribute(description="current number of connections", reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsCount() {
        return this.poolKeepAlive.size() + this.poolReadWrite.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsKeepAliveCount() {
        return this.poolKeepAlive.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsReadWriteCount() {
        return this.poolReadWrite.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsKeepAliveExpired() {
        return this.poolKeepAliveExpired;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsReadWriteExpired() {
        return this.poolReadWriteExpired;
    }

    @JmxOperation(description="number of connections per address")
    public String getAddressConnections() {
        if (this.addresses.isEmpty()) {
            return "";
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add("SocketAddress,ConnectionsCount");
        for (Map.Entry<InetSocketAddress, AddressLinkedList> entry : this.addresses.entrySet()) {
            InetSocketAddress address = entry.getKey();
            AddressLinkedList connections = entry.getValue();
            result.add(address + ", " + connections.size());
        }
        return MBeanFormat.formatListAsMultilineString(result);
    }

    @JmxAttribute
    @Nullable
    public TcpSocket.JmxInspector getSocketStats() {
        return (TcpSocket.JmxInspector)BaseInspector.lookup((BaseInspector)this.socketInspector, TcpSocket.JmxInspector.class);
    }

    @JmxAttribute
    @Nullable
    public TcpSocket.JmxInspector getSocketStatsSsl() {
        return (TcpSocket.JmxInspector)BaseInspector.lookup((BaseInspector)this.socketSslInspector, TcpSocket.JmxInspector.class);
    }

    @JmxAttribute(name="")
    @Nullable
    public JmxInspector getStats() {
        return (JmxInspector)BaseInspector.lookup((BaseInspector)this.inspector, JmxInspector.class);
    }

    public String toString() {
        return "HttpClient{read/write:" + this.poolReadWrite.size() + " keep-alive:" + this.poolKeepAlive.size() + "}";
    }

    public final class Builder
    extends AbstractBuilder<Builder, HttpClient> {
        private Builder() {
        }

        public Builder withSocketSettings(SocketSettings socketSettings) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.socketSettings = socketSettings;
            return this;
        }

        public Builder withSslEnabled(SSLContext sslContext, Executor sslExecutor) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.sslContext = sslContext;
            HttpClient.this.sslExecutor = sslExecutor;
            return this;
        }

        public Builder withKeepAliveTimeout(Duration keepAliveTime) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.keepAliveTimeoutMillis = (int)keepAliveTime.toMillis();
            return this;
        }

        public Builder withNoKeepAlive() {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withKeepAliveTimeout(Duration.ZERO);
        }

        public Builder withMaxKeepAliveRequests(int maxKeepAliveRequests) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            Checks.checkArgument((maxKeepAliveRequests >= 0 ? 1 : 0) != 0, (Object)"Maximum number of requests per keep-alive connection should not be less than zero");
            HttpClient.this.maxKeepAliveRequests = maxKeepAliveRequests;
            return this;
        }

        public Builder withReadWriteTimeout(Duration readWriteTimeout) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.readWriteTimeoutMillis = (int)readWriteTimeout.toMillis();
            return this;
        }

        public Builder withReadWriteTimeout(Duration readWriteTimeout, Duration readWriteTimeoutShutdown) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.readWriteTimeoutMillis = (int)readWriteTimeout.toMillis();
            HttpClient.this.readWriteTimeoutMillisShutdown = (int)readWriteTimeoutShutdown.toMillis();
            return this;
        }

        public Builder withConnectTimeout(Duration connectTimeout) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.connectTimeoutMillis = (int)connectTimeout.toMillis();
            return this;
        }

        public Builder withMaxBodySize(MemSize maxBodySize) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withMaxBodySize(maxBodySize.toInt());
        }

        public Builder withMaxBodySize(int maxBodySize) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.maxBodySize = maxBodySize != 0 ? maxBodySize : Integer.MAX_VALUE;
            return this;
        }

        public Builder withMaxWebSocketMessageSize(MemSize maxWebSocketMessageSize) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.maxWebSocketMessageSize = maxWebSocketMessageSize.toInt();
            return this;
        }

        public Builder withInspector(Inspector inspector) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.inspector = inspector;
            return this;
        }

        public Builder withSocketInspector(TcpSocket.Inspector socketInspector) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.socketInspector = socketInspector;
            return this;
        }

        public Builder withSocketSslInspector(TcpSocket.Inspector socketSslInspector) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.socketSslInspector = socketSslInspector;
            return this;
        }

        public Builder withForcedShutdown(boolean forcedShutdown) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            HttpClient.this.forcedShutdown = forcedShutdown;
            return this;
        }

        protected HttpClient doBuild() {
            return HttpClient.this;
        }
    }

    public static interface Inspector
    extends BaseInspector<Inspector> {
        public void onRequest(HttpRequest var1);

        public void onRequestComplete(HttpResponse var1, HttpClientConnection var2);

        public void onResolve(HttpRequest var1, DnsResponse var2);

        public void onResolveError(HttpRequest var1, Exception var2);

        public void onConnecting(HttpRequest var1, InetSocketAddress var2);

        public void onConnect(HttpRequest var1, HttpClientConnection var2);

        public void onConnectError(HttpRequest var1, InetSocketAddress var2, Exception var3);

        public void onHttpResponse(HttpResponse var1);

        public void onHttpError(HttpClientConnection var1, Exception var2);

        public void onMalformedHttpResponse(HttpClientConnection var1, MalformedHttpException var2, byte[] var3);

        public void onDisconnect(HttpClientConnection var1);
    }

    public static class JmxInspector
    extends AbstractInspector<Inspector>
    implements Inspector {
        private static final Duration SMOOTHING_WINDOW = Duration.ofMinutes(1L);
        private final EventStats totalRequests = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final ExceptionStats resolveErrors = ExceptionStats.create();
        private final EventStats connected = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final ExceptionStats connectErrors = ExceptionStats.create();
        private long responses;
        private final EventStats httpTimeouts = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final ExceptionStats httpErrors = ExceptionStats.create();
        private final ExceptionStats malformedHttpExceptions = ExceptionStats.create();
        private final EventStats sslErrors = EventStats.create((Duration)SMOOTHING_WINDOW);
        private int activeRequests;
        private int activeConnections;
        private int connecting;

        @Override
        public void onRequest(HttpRequest request) {
            ++this.activeRequests;
            this.totalRequests.recordEvent();
        }

        @Override
        public void onRequestComplete(HttpResponse response, HttpClientConnection httpClientConnection) {
            --this.activeRequests;
        }

        @Override
        public void onResolve(HttpRequest request, DnsResponse dnsResponse) {
        }

        @Override
        public void onResolveError(HttpRequest request, Exception e) {
            --this.activeRequests;
            this.resolveErrors.recordException((Throwable)e, (Object)request.getUrl().getHost());
        }

        @Override
        public void onConnecting(HttpRequest request, InetSocketAddress address) {
            ++this.connecting;
        }

        @Override
        public void onConnect(HttpRequest request, HttpClientConnection connection) {
            ++this.activeConnections;
            --this.connecting;
            this.connected.recordEvent();
        }

        @Override
        public void onConnectError(HttpRequest request, InetSocketAddress address, Exception e) {
            --this.activeRequests;
            --this.connecting;
            this.connectErrors.recordException((Throwable)e, (Object)request.getUrl().getHost());
        }

        @Override
        public void onHttpResponse(HttpResponse response) {
            ++this.responses;
        }

        @Override
        public void onHttpError(HttpClientConnection connection, Exception e) {
            if (connection.getCurrentPool() == PoolLabel.READ_WRITE) {
                --this.activeRequests;
            }
            if (e instanceof AsyncTimeoutException) {
                this.httpTimeouts.recordEvent();
                return;
            }
            this.httpErrors.recordException((Throwable)e);
            if (e instanceof SSLException) {
                this.sslErrors.recordEvent();
            }
        }

        @Override
        public void onMalformedHttpResponse(HttpClientConnection connection, MalformedHttpException e, byte[] malformedResponseBytes) {
            --this.activeRequests;
            String responseString = new String(malformedResponseBytes, StandardCharsets.ISO_8859_1);
            this.malformedHttpExceptions.recordException((Throwable)e, (Object)responseString);
        }

        @Override
        public void onDisconnect(HttpClientConnection connection) {
            --this.activeConnections;
        }

        @JmxAttribute(extraSubAttributes={"totalCount"}, description="all requests that were sent (both successful and failed)")
        public EventStats getTotalRequests() {
            return this.totalRequests;
        }

        @JmxAttribute
        public ExceptionStats getResolveErrors() {
            return this.resolveErrors;
        }

        @JmxAttribute
        public ExceptionStats getConnectErrors() {
            return this.connectErrors;
        }

        @JmxAttribute(description="number of \"open connection\" events)")
        public EventStats getConnected() {
            return this.connected;
        }

        @JmxAttribute
        public EventStats getHttpTimeouts() {
            return this.httpTimeouts;
        }

        @JmxAttribute
        public ExceptionStats getHttpErrors() {
            return this.httpErrors;
        }

        @JmxAttribute
        public ExceptionStats getMalformedHttpExceptions() {
            return this.malformedHttpExceptions;
        }

        @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
        public int getActiveRequests() {
            return this.activeRequests;
        }

        @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
        public long getTotalResponses() {
            return this.responses;
        }

        @JmxAttribute
        public EventStats getSslErrors() {
            return this.sslErrors;
        }

        @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
        public int getActiveConnections() {
            return this.activeConnections;
        }

        @JmxAttribute(description="number of \"currently connecting\" sockets)", reducer=JmxReducers.JmxReducerSum.class)
        public int getConnecting() {
            return this.connecting;
        }
    }
}

