/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.ApplicationSettings;
import io.activej.common.Utils;
import io.activej.http.CaseInsensitiveTokenMap;
import io.activej.http.MalformedHttpException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class HttpCharset
extends CaseInsensitiveTokenMap.Token {
    private static final int SLOTS_NUMBER = ApplicationSettings.getInt(HttpCharset.class, (String)"slotsNumber", (Integer)512);
    private static final int MAX_PROBINGS = ApplicationSettings.getInt(HttpCharset.class, (String)"maxProbings", (Integer)2);
    private static final CaseInsensitiveTokenMap<HttpCharset> charsets = new CaseInsensitiveTokenMap<HttpCharset>(SLOTS_NUMBER, MAX_PROBINGS, HttpCharset::new, HttpCharset[]::new);
    private static final Map<Charset, HttpCharset> java2http = new HashMap<Charset, HttpCharset>();
    public static final HttpCharset UTF_8 = HttpCharset.register("utf-8", StandardCharsets.UTF_8);
    public static final HttpCharset US_ASCII = HttpCharset.register("us-ascii", StandardCharsets.US_ASCII);
    public static final HttpCharset LATIN_1 = HttpCharset.register("iso-8859-1", StandardCharsets.ISO_8859_1);
    private Charset javaCharset;

    private HttpCharset(int hashCodeCI, byte[] bytes, int offset, int length, byte @Nullable [] lowerCaseBytes) {
        super(hashCodeCI, bytes, offset, length, lowerCaseBytes);
    }

    public static HttpCharset register(String charsetName, Charset charset) {
        return charsets.register(charsetName).addCharset(charset);
    }

    static HttpCharset of(Charset charset) {
        HttpCharset hCharset = java2http.get(charset);
        if (hCharset != null) {
            return hCharset;
        }
        byte[] bytes = ByteBufStrings.encodeAscii((String)charset.name());
        return HttpCharset.decode(bytes, 0, bytes.length);
    }

    static HttpCharset decode(byte[] bytes, int pos, int length) {
        return charsets.getOrCreate(bytes, pos, length);
    }

    static int render(HttpCharset charset, byte[] container, int pos) {
        System.arraycopy(charset.bytes, charset.offset, container, pos, charset.length);
        return charset.length;
    }

    private HttpCharset addCharset(Charset charset) {
        this.javaCharset = charset;
        java2http.put(charset, this);
        return this;
    }

    Charset toJavaCharset() throws MalformedHttpException {
        if (this.javaCharset == null) {
            String charsetName = ByteBufStrings.decodeAscii((byte[])this.bytes, (int)this.offset, (int)this.length);
            try {
                if (charsetName.startsWith("\"") || charsetName.startsWith("'")) {
                    charsetName = charsetName.substring(1, charsetName.length() - 1);
                }
                this.javaCharset = Charset.forName(charsetName);
            }
            catch (Exception e) {
                throw new MalformedHttpException("Can't fetch charset for " + charsetName, e);
            }
        }
        return this.javaCharset;
    }

    int size() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpCharset that = (HttpCharset)o;
        return Utils.arraysEquals((byte[])this.bytes, (int)this.offset, (int)this.length, (byte[])that.bytes, (int)that.offset, (int)that.length);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.bytes);
        result = 31 * result + this.offset;
        result = 31 * result + this.length;
        return result;
    }

    public String toString() {
        return ByteBufStrings.decodeAscii((byte[])this.bytes, (int)this.offset, (int)this.length);
    }
}

