/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.function.AsyncBiPredicate;
import io.activej.common.Checks;
import io.activej.common.builder.AbstractBuilder;
import io.activej.http.AsyncServlet;
import io.activej.http.ContentTypes;
import io.activej.http.HttpError;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.promise.Promise;
import io.activej.reactor.AbstractReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class BasicAuthServlet
extends AbstractReactive
implements AsyncServlet {
    private static final boolean CHECKS = Checks.isEnabled(BasicAuthServlet.class);
    public static final BiPredicate<String, String> SILLY = (login, pass) -> true;
    private static final String PREFIX = "Basic ";
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private final AsyncServlet next;
    private final String challenge;
    private final AsyncBiPredicate<String, String> credentialsLookup;
    private UnaryOperator<HttpResponse.Builder> failureResponse = response -> (HttpResponse.Builder)((HttpResponse.Builder)response.withHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType(ContentTypes.PLAIN_TEXT_UTF_8))).withBody("Authentication is required".getBytes(StandardCharsets.UTF_8));

    private BasicAuthServlet(Reactor reactor, AsyncServlet next, String realm, AsyncBiPredicate<String, String> credentialsLookup) {
        super(reactor);
        this.next = next;
        this.credentialsLookup = credentialsLookup;
        this.challenge = "Basic realm=\"" + realm + "\", charset=\"UTF-8\"";
    }

    public static BasicAuthServlet create(Reactor reactor, AsyncServlet next, String realm, AsyncBiPredicate<String, String> credentialsLookup) {
        return (BasicAuthServlet)BasicAuthServlet.builder(reactor, next, realm, credentialsLookup).build();
    }

    public static Builder builder(Reactor reactor, AsyncServlet next, String realm, AsyncBiPredicate<String, String> credentialsLookup) {
        return new BasicAuthServlet(reactor, next, realm, credentialsLookup).new Builder();
    }

    public static Function<AsyncServlet, AsyncServlet> decorator(Reactor reactor, String realm, AsyncBiPredicate<String, String> credentialsLookup) {
        return next -> BasicAuthServlet.create(reactor, next, realm, credentialsLookup);
    }

    public static Function<AsyncServlet, AsyncServlet> decorator(Reactor reactor, String realm, AsyncBiPredicate<String, String> credentialsLookup, UnaryOperator<HttpResponse.Builder> failureResponse) {
        return next -> (AsyncServlet)BasicAuthServlet.builder(reactor, next, realm, credentialsLookup).withFailureResponse(failureResponse).build();
    }

    @Override
    public Promise<HttpResponse> serve(HttpRequest request) throws HttpError {
        byte[] raw;
        String header;
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if ((header = request.getHeader(HttpHeaders.AUTHORIZATION)) == null || !header.startsWith(PREFIX)) {
            return ((HttpResponse.Builder)this.failureResponse.apply(HttpResponse.unauthorized401(this.challenge))).toPromise();
        }
        try {
            raw = DECODER.decode(header.substring(PREFIX.length()));
        }
        catch (IllegalArgumentException e) {
            throw HttpError.ofCode(400, "Base64: " + e.getMessage());
        }
        String[] authData = new String(raw, StandardCharsets.UTF_8).split(":", 2);
        if (authData.length != 2) {
            throw HttpError.ofCode(400, "No ':' separator");
        }
        return this.credentialsLookup.test((Object)authData[0], (Object)authData[1]).then(ok -> {
            if (!ok.booleanValue()) {
                return ((HttpResponse.Builder)this.failureResponse.apply(HttpResponse.unauthorized401(this.challenge))).toPromise();
            }
            request.attach(new BasicAuthCredentials(authData[0], authData[1]));
            return this.next.serve(request);
        });
    }

    public static BiPredicate<String, String> lookupFrom(Map<String, String> credentials) {
        return (login, pass) -> pass.equals(credentials.get(login));
    }

    public final class Builder
    extends AbstractBuilder<Builder, BasicAuthServlet> {
        private Builder() {
        }

        public Builder withFailureResponse(UnaryOperator<HttpResponse.Builder> failureResponse) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            BasicAuthServlet.this.failureResponse = failureResponse;
            return this;
        }

        protected BasicAuthServlet doBuild() {
            return BasicAuthServlet.this;
        }
    }

    public record BasicAuthCredentials(String username, String password) {
    }
}

