/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dns.protocol;

import io.activej.dns.protocol.DnsQuery;

public final class DnsTransaction {
    private final short id;
    private final DnsQuery query;

    private DnsTransaction(short id, DnsQuery query) {
        this.id = id;
        this.query = query;
    }

    public static DnsTransaction of(short transactionId, DnsQuery query) {
        return new DnsTransaction(transactionId, query);
    }

    public short getId() {
        return this.id;
    }

    public DnsQuery getQuery() {
        return this.query;
    }

    public String toString() {
        return "DnsTransaction{id=" + Integer.toHexString(this.id & 0xFFFF) + ", query='" + this.query + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsTransaction that = (DnsTransaction)o;
        return this.id == that.id && this.query.equals(that.query);
    }

    public int hashCode() {
        return 31 * this.id + this.query.hashCode();
    }
}

