/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.supplier.impl;

import io.activej.common.collection.IteratorUtils;
import io.activej.csp.supplier.AbstractChannelSupplier;
import io.activej.csp.supplier.ChannelSupplier;
import io.activej.promise.Promise;
import io.activej.promise.SettableCallback;
import java.util.Iterator;
import java.util.function.Function;

public final class Remap<T, V>
extends AbstractChannelSupplier<V> {
    public final ChannelSupplier<T> supplier;
    public final Function<? super T, ? extends Iterator<? extends V>> fn;
    public Iterator<? extends V> iterator;
    public boolean endOfStream;

    public Remap(ChannelSupplier<T> supplier, Function<? super T, ? extends Iterator<? extends V>> fn) {
        super(supplier);
        this.supplier = supplier;
        this.fn = fn;
        this.iterator = IteratorUtils.iteratorOf();
    }

    @Override
    protected Promise<V> doGet() {
        if (this.iterator.hasNext()) {
            return Promise.of(this.iterator.next());
        }
        return Promise.ofCallback(this::next);
    }

    private void next(SettableCallback<V> cb) {
        if (!this.endOfStream) {
            this.supplier.get().subscribe((item, e) -> {
                if (e == null) {
                    if (item == null) {
                        this.endOfStream = true;
                    }
                    this.iterator = this.fn.apply(item);
                    if (this.iterator.hasNext()) {
                        cb.set(this.iterator.next());
                    } else {
                        this.next(cb);
                    }
                } else {
                    cb.setException(e);
                }
            });
        } else {
            cb.set(null);
        }
    }
}

