/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.supplier.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.csp.supplier.AbstractChannelSupplier;
import io.activej.promise.Promise;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

public final class OfInputStream
extends AbstractChannelSupplier<ByteBuf> {
    public final Executor executor;
    public final int bufSize;
    public final InputStream inputStream;

    public OfInputStream(Executor executor, int bufSize, InputStream inputStream) {
        this.executor = executor;
        this.bufSize = bufSize;
        this.inputStream = inputStream;
    }

    @Override
    protected Promise<ByteBuf> doGet() {
        return Promise.ofBlocking((Executor)this.executor, () -> {
            int readBytes;
            ByteBuf buf = ByteBufPool.allocate((int)this.bufSize);
            try {
                readBytes = this.inputStream.read(buf.array(), 0, this.bufSize);
            }
            catch (IOException e) {
                buf.recycle();
                throw e;
            }
            if (readBytes != -1) {
                buf.moveTail(readBytes);
                return buf;
            }
            buf.recycle();
            return null;
        });
    }

    protected void onClosed(Exception e) {
        this.executor.execute(() -> {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

