/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.supplier;

import io.activej.async.function.AsyncSupplier;
import io.activej.async.process.AsyncCloseable;
import io.activej.bytebuf.ByteBuf;
import io.activej.common.MemSize;
import io.activej.common.function.SupplierEx;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.csp.queue.ChannelBuffer;
import io.activej.csp.queue.ChannelQueue;
import io.activej.csp.queue.ChannelZeroBuffer;
import io.activej.csp.supplier.ChannelSupplier;
import io.activej.csp.supplier.impl.Concat;
import io.activej.csp.supplier.impl.Empty;
import io.activej.csp.supplier.impl.OfAnotherReactor;
import io.activej.csp.supplier.impl.OfAsyncSupplier;
import io.activej.csp.supplier.impl.OfException;
import io.activej.csp.supplier.impl.OfInputStream;
import io.activej.csp.supplier.impl.OfIterator;
import io.activej.csp.supplier.impl.OfLazyProvider;
import io.activej.csp.supplier.impl.OfPromise;
import io.activej.csp.supplier.impl.OfSupplier;
import io.activej.csp.supplier.impl.OfValue;
import io.activej.csp.supplier.impl.Remap;
import io.activej.net.socket.tcp.ITcpSocket;
import io.activej.promise.Promise;
import io.activej.reactor.Reactor;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class ChannelSuppliers {
    private static final MemSize DEFAULT_BUFFER_SIZE = MemSize.kilobytes((long)8L);

    public static <T> ChannelSupplier<T> ofAsyncSupplier(AsyncSupplier<T> supplier) {
        return ChannelSuppliers.ofAsyncSupplier(supplier, null);
    }

    public static <T> ChannelSupplier<T> ofAsyncSupplier(AsyncSupplier<T> supplier, @Nullable AsyncCloseable closeable) {
        return new OfAsyncSupplier<T>(supplier, closeable);
    }

    public static <T> ChannelSupplier<T> ofSupplier(SupplierEx<T> supplier) {
        return ChannelSuppliers.ofSupplier(supplier, null);
    }

    public static <T> ChannelSupplier<T> ofSupplier(SupplierEx<T> supplier, @Nullable AsyncCloseable closeable) {
        return new OfSupplier<T>(supplier, closeable);
    }

    public static <T> ChannelSupplier<T> ofConsumer(Consumer<ChannelConsumer<T>> consumer, ChannelQueue<T> queue) {
        consumer.accept(queue.getConsumer());
        return queue.getSupplier();
    }

    public static <T> ChannelSupplier<T> empty() {
        return new Empty();
    }

    public static <T> ChannelSupplier<T> ofValue(T value) {
        return new OfValue<T>(value);
    }

    public static <T> ChannelSupplier<T> ofValues() {
        return ChannelSuppliers.empty();
    }

    public static <T> ChannelSupplier<T> ofValues(T value) {
        return ChannelSuppliers.ofValue(value);
    }

    @SafeVarargs
    public static <T> ChannelSupplier<T> ofValues(T ... values) {
        return ChannelSuppliers.ofList(List.of(values));
    }

    public static <T> ChannelSupplier<T> ofException(Exception e) {
        return new OfException(e);
    }

    public static <T> ChannelSupplier<T> ofList(List<? extends T> list) {
        return new OfIterator<T>(list.iterator(), true);
    }

    public static <T> ChannelSupplier<T> ofStream(Stream<? extends T> stream) {
        return ChannelSuppliers.ofIterator(stream.iterator());
    }

    public static <T> ChannelSupplier<T> ofIterator(Iterator<? extends T> iterator) {
        return new OfIterator<T>(iterator, false);
    }

    public static ChannelSupplier<ByteBuf> ofSocket(ITcpSocket socket) {
        return ChannelSuppliers.prefetch(ChannelSuppliers.ofAsyncSupplier(() -> ((ITcpSocket)socket).read(), (AsyncCloseable)socket));
    }

    public static <T> ChannelSupplier<T> ofPromise(Promise<? extends ChannelSupplier<T>> promise) {
        if (promise.isResult()) {
            return (ChannelSupplier)promise.getResult();
        }
        return new OfPromise(promise);
    }

    public static <T> ChannelSupplier<T> ofAnotherReactor(Reactor anotherReactor, ChannelSupplier<T> anotherReactorSupplier) {
        if (Reactor.getCurrentReactor() == anotherReactor) {
            return anotherReactorSupplier;
        }
        return new OfAnotherReactor<T>(anotherReactor, anotherReactorSupplier);
    }

    public static <T> ChannelSupplier<T> ofLazyProvider(Supplier<? extends ChannelSupplier<T>> provider) {
        return new OfLazyProvider(provider);
    }

    public static <T> ChannelSupplier<T> concat(ChannelSupplier<? extends T> supplier1, ChannelSupplier<? extends T> supplier2) {
        return ChannelSuppliers.concat(List.of(supplier1, supplier2));
    }

    @SafeVarargs
    public static <T> ChannelSupplier<T> concat(ChannelSupplier<? extends T> ... suppliers) {
        return ChannelSuppliers.concat(List.of(suppliers));
    }

    public static <T> ChannelSupplier<T> concat(List<ChannelSupplier<? extends T>> suppliers) {
        return new Concat<T>(suppliers.iterator(), true);
    }

    public static <T> ChannelSupplier<T> concat(Iterator<? extends ChannelSupplier<? extends T>> iterator) {
        return new Concat(iterator, false);
    }

    public static <T> ChannelSupplier<T> prefetch(int count, ChannelSupplier<T> actual) {
        ChannelBuffer buffer = new ChannelBuffer(count);
        actual.streamTo(buffer.getConsumer());
        return buffer.getSupplier();
    }

    public static <T> ChannelSupplier<T> prefetch(ChannelSupplier<T> actual) {
        ChannelZeroBuffer buffer = new ChannelZeroBuffer();
        actual.streamTo(buffer.getConsumer());
        return buffer.getSupplier();
    }

    public static <T, V> ChannelSupplier<V> remap(ChannelSupplier<T> supplier, Function<? super T, ? extends Iterator<? extends V>> fn) {
        return new Remap(supplier, fn);
    }

    public static ChannelSupplier<ByteBuf> ofInputStream(Executor executor, MemSize bufSize, InputStream is) {
        return ChannelSuppliers.ofInputStream(executor, bufSize.toInt(), is);
    }

    public static ChannelSupplier<ByteBuf> ofInputStream(Executor executor, InputStream is) {
        return ChannelSuppliers.ofInputStream(executor, DEFAULT_BUFFER_SIZE, is);
    }

    public static ChannelSupplier<ByteBuf> ofInputStream(Executor executor, int bufSize, InputStream inputStream) {
        return new OfInputStream(executor, bufSize, inputStream);
    }
}

