/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.queue;

import io.activej.async.process.AsyncCloseable;
import io.activej.common.Checks;
import io.activej.common.recycle.Recyclers;
import io.activej.csp.queue.ChannelQueue;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import io.activej.reactor.ImplicitlyReactive;
import io.activej.reactor.Reactive;
import org.jetbrains.annotations.Nullable;

public final class ChannelZeroBuffer<T>
extends ImplicitlyReactive
implements ChannelQueue<T> {
    private static final boolean CHECKS = Checks.isEnabled(ChannelZeroBuffer.class);
    private Exception exception;
    @Nullable
    private T value;
    @Nullable
    private SettablePromise<Void> put;
    @Nullable
    private SettablePromise<T> take;
    @Nullable
    private AsyncCloseable closeable;

    public void setCloseable(@Nullable AsyncCloseable closeable) {
        this.closeable = closeable;
    }

    @Override
    public boolean isSaturated() {
        return this.take == null;
    }

    @Override
    public boolean isExhausted() {
        return this.put == null;
    }

    @Override
    public Promise<Void> put(@Nullable T item) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
            Checks.checkState((this.put == null ? 1 : 0) != 0, (Object)"Previous put() has not finished yet");
        }
        if (this.exception == null) {
            if (this.take != null) {
                SettablePromise<T> take = this.take;
                this.take = null;
                take.set(item);
                return Promise.complete();
            }
            this.value = item;
            this.put = new SettablePromise();
            return this.put;
        }
        Recyclers.recycle(item);
        return Promise.ofException((Exception)this.exception);
    }

    @Override
    public Promise<T> take() {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
            Checks.checkState((this.take == null ? 1 : 0) != 0, (Object)"Previous take() has not finished yet");
        }
        if (this.exception == null) {
            if (this.put != null) {
                T value = this.value;
                SettablePromise<Void> put = this.put;
                this.value = null;
                this.put = null;
                put.set(null);
                return Promise.of(value);
            }
            this.take = new SettablePromise();
            return this.take;
        }
        return Promise.ofException((Exception)this.exception);
    }

    public void closeEx(Exception e) {
        Reactive.checkInReactorThread((Reactive)this);
        if (this.exception != null) {
            return;
        }
        this.exception = e;
        if (this.put != null) {
            this.put.setException(e);
            this.put = null;
        }
        if (this.take != null) {
            this.take.setException(e);
            this.take = null;
        }
        Recyclers.recycle(this.value);
        this.value = null;
        if (this.closeable != null) {
            this.closeable.closeEx(e);
            this.closeable = null;
        }
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }
}

