/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.transformer;

import io.activej.bytebuf.ByteBuf;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.csp.process.transformer.ChannelTransformer;
import io.activej.csp.process.transformer.impl.ByteChunker;
import io.activej.csp.process.transformer.impl.ByteRanger;
import io.activej.csp.supplier.ChannelSupplier;

public class ChannelTransformers {
    public static <T> ChannelTransformer<T, T> identity() {
        return new ChannelTransformer<T, T>(){

            @Override
            public ChannelConsumer<T> transform(ChannelConsumer<T> consumer) {
                return consumer;
            }

            @Override
            public ChannelSupplier<T> transform(ChannelSupplier<T> supplier) {
                return supplier;
            }
        };
    }

    public static ChannelTransformer<ByteBuf, ByteBuf> chunkBytes(MemSize minChunkSize, MemSize maxChunkSize) {
        Checks.checkArgument((Object)minChunkSize.toInt(), minSize -> minSize > 0, (Object)"Minimal chunk size should be greater than 0");
        Checks.checkArgument((Object)maxChunkSize.toInt(), maxSize -> maxSize >= minChunkSize.toInt(), (Object)"Maximal chunk size cannot be less than minimal chunk size");
        return new ByteChunker(minChunkSize.toInt(), maxChunkSize.toInt());
    }

    public static ChannelTransformer<ByteBuf, ByteBuf> rangeBytes(long offset, long length) {
        if (offset == 0L && length == Long.MAX_VALUE) {
            return ChannelTransformers.identity();
        }
        return new ByteRanger(offset, length);
    }

    public static ChannelTransformer<ByteBuf, ByteBuf> dropBytes(long toDrop) {
        return ChannelTransformers.rangeBytes(toDrop, Long.MAX_VALUE);
    }

    public static ChannelTransformer<ByteBuf, ByteBuf> limitBytes(long limit) {
        return ChannelTransformers.rangeBytes(0L, limit);
    }
}

