/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frame.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.MalformedDataException;
import io.activej.csp.binary.decoder.ByteBufsDecoder;
import io.activej.csp.binary.decoder.ByteBufsDecoders;
import io.activej.csp.process.frame.BlockDecoder;
import io.activej.csp.process.frame.BlockEncoder;
import io.activej.csp.process.frame.FrameFormat;

public final class MagicNumberAdapter
implements FrameFormat {
    public final FrameFormat peerFormat;
    public final byte[] magicNumber;
    private final ByteBufsDecoder<byte[]> magicNumberValidator;

    public MagicNumberAdapter(FrameFormat peerFormat, byte[] magicNumber) {
        this.peerFormat = peerFormat;
        this.magicNumber = magicNumber;
        this.magicNumberValidator = ByteBufsDecoders.assertBytes(magicNumber);
    }

    @Override
    public BlockEncoder createEncoder() {
        return new BlockEncoder(){
            final BlockEncoder peer;
            boolean writeMagicNumber;
            {
                this.peer = MagicNumberAdapter.this.peerFormat.createEncoder();
                this.writeMagicNumber = true;
            }

            @Override
            public ByteBuf encode(ByteBuf inputBuf) {
                ByteBuf peerEncoded = this.peer.encode(inputBuf);
                if (this.writeMagicNumber) {
                    this.writeMagicNumber = false;
                    return ByteBufPool.append((ByteBuf)ByteBuf.wrapForReading((byte[])MagicNumberAdapter.this.magicNumber), (ByteBuf)peerEncoded);
                }
                return peerEncoded;
            }

            @Override
            public void reset() {
                this.writeMagicNumber = true;
            }

            @Override
            public ByteBuf encodeEndOfStreamBlock() {
                ByteBuf peerEncodedEndOfStream = this.peer.encodeEndOfStreamBlock();
                if (this.writeMagicNumber) {
                    this.writeMagicNumber = false;
                    return ByteBufPool.append((ByteBuf)ByteBuf.wrapForReading((byte[])MagicNumberAdapter.this.magicNumber), (ByteBuf)peerEncodedEndOfStream);
                }
                return peerEncodedEndOfStream;
            }
        };
    }

    @Override
    public BlockDecoder createDecoder() {
        return new BlockDecoder(){
            final BlockDecoder peer;
            boolean validateMagicNumber;
            {
                this.peer = MagicNumberAdapter.this.peerFormat.createDecoder();
                this.validateMagicNumber = true;
            }

            @Override
            public ByteBuf decode(ByteBufs bufs) throws MalformedDataException {
                if (this.validateMagicNumber) {
                    if (MagicNumberAdapter.this.magicNumberValidator.tryDecode(bufs) == null) {
                        return null;
                    }
                    this.validateMagicNumber = false;
                }
                return this.peer.decode(bufs);
            }

            @Override
            public void reset() {
                this.validateMagicNumber = true;
            }

            @Override
            public boolean ignoreMissingEndOfStreamBlock() {
                return this.peer.ignoreMissingEndOfStreamBlock();
            }
        };
    }
}

