/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frame.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.UnknownFormatException;
import io.activej.csp.process.frame.BlockDecoder;
import io.activej.csp.process.frame.BlockEncoder;
import io.activej.csp.process.frame.FrameFormat;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class Compound
implements FrameFormat {
    public final List<FrameFormat> formats;

    public Compound(List<FrameFormat> formats) {
        this.formats = formats;
    }

    @Override
    public BlockEncoder createEncoder() {
        return this.formats.get(0).createEncoder();
    }

    @Override
    public BlockDecoder createDecoder() {
        return new BlockDecoder(){
            BlockDecoder decoder;
            BlockDecoder possibleDecoder;
            Iterator<FrameFormat> possibleDecoders;
            {
                this.possibleDecoders = Compound.this.formats.iterator();
            }

            @Override
            public void reset() {
                if (this.decoder != null) {
                    this.decoder.reset();
                }
            }

            @Override
            public boolean ignoreMissingEndOfStreamBlock() {
                if (this.decoder != null) {
                    return this.decoder.ignoreMissingEndOfStreamBlock();
                }
                return Compound.this.formats.stream().map(FrameFormat::createDecoder).anyMatch(BlockDecoder::ignoreMissingEndOfStreamBlock);
            }

            @Override
            @Nullable
            public ByteBuf decode(ByteBufs bufs) throws MalformedDataException {
                if (this.decoder != null) {
                    return this.decoder.decode(bufs);
                }
                return this.tryNextDecoder(bufs);
            }

            private ByteBuf tryNextDecoder(ByteBufs bufs) throws MalformedDataException {
                while (true) {
                    if (this.possibleDecoder == null) {
                        if (!this.possibleDecoders.hasNext()) {
                            throw new UnknownFormatException();
                        }
                        this.possibleDecoder = this.possibleDecoders.next().createDecoder();
                    }
                    try {
                        int bytesBeforeDecoding = bufs.remainingBytes();
                        ByteBuf buf = this.possibleDecoder.decode(bufs);
                        if (buf != null || bytesBeforeDecoding != bufs.remainingBytes()) {
                            this.decoder = this.possibleDecoder;
                            this.possibleDecoders = null;
                        }
                        return buf;
                    }
                    catch (MalformedDataException malformedDataException) {
                        this.possibleDecoder = null;
                        continue;
                    }
                    break;
                }
            }
        };
    }
}

