/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.file;

import io.activej.async.file.ExecutorFileService;
import io.activej.async.file.IFileService;
import io.activej.bytebuf.ByteBuf;
import io.activej.common.Checks;
import io.activej.common.builder.AbstractBuilder;
import io.activej.csp.consumer.AbstractChannelConsumer;
import io.activej.promise.Promise;
import io.activej.reactor.Reactor;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelFileWriter
extends AbstractChannelConsumer<ByteBuf> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelFileWriter.class);
    private static final OpenOption[] DEFAULT_OPTIONS = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.APPEND};
    private final IFileService fileService;
    private final FileChannel channel;
    private boolean forceOnClose = false;
    private boolean forceMetadata = false;
    private long startingOffset = 0L;
    private boolean started;
    private long position = 0L;

    private ChannelFileWriter(IFileService fileService, FileChannel channel) {
        this.fileService = fileService;
        this.channel = channel;
    }

    public static ChannelFileWriter create(Reactor reactor, Executor executor, FileChannel channel) {
        return (ChannelFileWriter)ChannelFileWriter.builder(reactor, executor, channel).build();
    }

    public static ChannelFileWriter create(IFileService fileService, FileChannel channel) {
        return (ChannelFileWriter)ChannelFileWriter.builder(fileService, channel).build();
    }

    public static Promise<ChannelFileWriter> open(Executor executor, Path path) {
        return ChannelFileWriter.open(executor, path, DEFAULT_OPTIONS);
    }

    public static Promise<ChannelFileWriter> open(Executor executor, Path path, OpenOption ... openOptions) {
        return ChannelFileWriter.builderOpen(executor, path, openOptions).map(AbstractBuilder::build);
    }

    public static ChannelFileWriter openBlocking(Reactor reactor, Executor executor, Path path) throws IOException {
        return ChannelFileWriter.openBlocking(reactor, executor, path, DEFAULT_OPTIONS);
    }

    public static ChannelFileWriter openBlocking(Reactor reactor, Executor executor, Path path, OpenOption ... openOptions) throws IOException {
        return (ChannelFileWriter)ChannelFileWriter.builderBlocking(reactor, executor, path, openOptions).build();
    }

    public static Builder builder(Reactor reactor, Executor executor, FileChannel channel) {
        return ChannelFileWriter.builder((IFileService)new ExecutorFileService(reactor, executor), channel);
    }

    public static Builder builder(IFileService fileService, FileChannel channel) {
        return new ChannelFileWriter(fileService, channel).new Builder();
    }

    public static Promise<Builder> builderOpen(Executor executor, Path path) {
        return ChannelFileWriter.builderOpen(executor, path, DEFAULT_OPTIONS);
    }

    public static Promise<Builder> builderOpen(Executor executor, Path path, OpenOption ... openOptions) {
        Checks.checkArgument((boolean)List.of(openOptions).contains(StandardOpenOption.WRITE), (Object)"'WRITE' option is not present");
        return Promise.ofBlocking((Executor)executor, () -> FileChannel.open(path, openOptions)).map(channel -> ChannelFileWriter.builder(Reactor.getCurrentReactor(), executor, channel));
    }

    public static Builder builderBlocking(Reactor reactor, Executor executor, Path path, OpenOption ... openOptions) throws IOException {
        Checks.checkArgument((boolean)List.of(openOptions).contains(StandardOpenOption.WRITE), (Object)"'WRITE' option is not present");
        FileChannel channel = FileChannel.open(path, openOptions);
        return ChannelFileWriter.builder(reactor, executor, channel);
    }

    public long getPosition() {
        return this.position;
    }

    protected void onClosed(Exception e) {
        try {
            this.closeFile();
        }
        catch (IOException ex) {
            logger.error("{}: failed to close file", (Object)this, (Object)ex);
        }
    }

    @Override
    protected Promise<Void> doAccept(ByteBuf buf) {
        if (!this.started) {
            this.position = this.startingOffset;
        }
        this.started = true;
        if (buf == null) {
            try {
                this.closeFile();
            }
            catch (IOException e) {
                return Promise.ofException((Exception)e);
            }
            this.close();
            return Promise.of(null);
        }
        long p = this.position;
        this.position += (long)buf.readRemaining();
        byte[] array = buf.asArray();
        return this.fileService.write(this.channel, p, array, 0, array.length).then(($, e2) -> {
            if (this.isClosed()) {
                return Promise.ofException((Exception)this.getException());
            }
            if (e2 != null) {
                this.closeEx((Exception)e2);
            }
            return Promise.of(null, (Exception)e2);
        });
    }

    private void closeFile() throws IOException {
        if (!this.channel.isOpen()) {
            return;
        }
        if (this.forceOnClose) {
            this.channel.force(this.forceMetadata);
        }
        this.channel.close();
        logger.trace("{}: closed file", (Object)this);
    }

    public String toString() {
        return "ChannelFileWriter{pos=" + this.position + "}";
    }

    public final class Builder
    extends AbstractBuilder<Builder, ChannelFileWriter> {
        private Builder() {
        }

        public Builder withForceOnClose(boolean forceMetadata) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ChannelFileWriter.this.forceOnClose = true;
            ChannelFileWriter.this.forceMetadata = forceMetadata;
            return this;
        }

        public Builder withOffset(long offset) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ChannelFileWriter.this.startingOffset = offset;
            return this;
        }

        protected ChannelFileWriter doBuild() {
            return ChannelFileWriter.this;
        }
    }
}

