/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.consumer;

import io.activej.async.function.AsyncConsumer;
import io.activej.async.process.AsyncCloseable;
import io.activej.bytebuf.ByteBuf;
import io.activej.common.function.ConsumerEx;
import io.activej.common.recycle.Recyclable;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.csp.consumer.impl.OfAnotherReactor;
import io.activej.csp.consumer.impl.OfAsyncConsumer;
import io.activej.csp.consumer.impl.OfConsumer;
import io.activej.csp.consumer.impl.OfException;
import io.activej.csp.consumer.impl.OfLazyProvider;
import io.activej.csp.consumer.impl.OfOutputStream;
import io.activej.csp.consumer.impl.OfPromise;
import io.activej.csp.consumer.impl.Recycling;
import io.activej.csp.queue.ChannelQueue;
import io.activej.csp.queue.ChannelZeroBuffer;
import io.activej.csp.supplier.ChannelSupplier;
import io.activej.net.socket.tcp.ITcpSocket;
import io.activej.promise.Promise;
import io.activej.reactor.Reactor;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class ChannelConsumers {
    public static <T> ChannelConsumer<T> ofAsyncConsumer(AsyncConsumer<T> consumer) {
        return ChannelConsumers.ofAsyncConsumer(consumer, AsyncCloseable.of(e -> {}));
    }

    public static <T> ChannelConsumer<T> ofAsyncConsumer(AsyncConsumer<T> consumer, @Nullable AsyncCloseable closeable) {
        return new OfAsyncConsumer<T>(consumer, closeable);
    }

    public static <T> ChannelConsumer<T> ofConsumer(ConsumerEx<T> consumer) {
        return ChannelConsumers.ofConsumer(consumer, null);
    }

    public static <T> ChannelConsumer<T> ofConsumer(ConsumerEx<T> consumer, @Nullable AsyncCloseable closeable) {
        return new OfConsumer<T>(consumer, closeable);
    }

    public static <T> ChannelConsumer<T> ofException(Exception e) {
        return new OfException(e);
    }

    public static <T> ChannelConsumer<T> ofSupplier(AsyncConsumer<ChannelSupplier<T>> supplierConsumer) {
        return ChannelConsumers.ofSupplier(supplierConsumer, new ChannelZeroBuffer());
    }

    public static <T> ChannelConsumer<T> ofSupplier(AsyncConsumer<ChannelSupplier<T>> supplierConsumer, ChannelQueue<T> queue) {
        Promise extraAcknowledge = supplierConsumer.accept(queue.getSupplier());
        ChannelConsumer<T> result = queue.getConsumer();
        if (extraAcknowledge == Promise.complete()) {
            return result;
        }
        return result.withAcknowledgement(ack -> ack.both(extraAcknowledge));
    }

    public static <T> ChannelConsumer<T> ofPromise(Promise<? extends ChannelConsumer<T>> promise) {
        if (promise.isResult()) {
            return (ChannelConsumer)promise.getResult();
        }
        return new OfPromise(promise);
    }

    public static <T> ChannelConsumer<T> ofAnotherReactor(Reactor anotherReactor, ChannelConsumer<T> anotherReactorConsumer) {
        if (Reactor.getCurrentReactor() == anotherReactor) {
            return anotherReactorConsumer;
        }
        return new OfAnotherReactor<T>(anotherReactor, anotherReactorConsumer);
    }

    public static <T> ChannelConsumer<T> ofLazyProvider(Supplier<? extends ChannelConsumer<T>> provider) {
        return new OfLazyProvider(provider);
    }

    public static ChannelConsumer<ByteBuf> ofSocket(ITcpSocket socket) {
        return ChannelConsumers.ofAsyncConsumer(arg_0 -> ((ITcpSocket)socket).write(arg_0), (AsyncCloseable)socket).withAcknowledgement(ack -> ack.then(() -> socket.write(null)));
    }

    public static <T extends Recyclable> ChannelConsumer<T> recycling() {
        return new Recycling();
    }

    public static ChannelConsumer<ByteBuf> ofOutputStream(Executor executor, OutputStream outputStream) {
        return new OfOutputStream(executor, outputStream);
    }
}

