/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.binary.decoder.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.csp.binary.Utils;
import io.activej.csp.binary.decoder.ByteBufsDecoder;
import org.jetbrains.annotations.Nullable;

public final class OfVarIntSizePrefixed
implements ByteBufsDecoder<ByteBuf> {
    public final Utils.VarIntByteScanner scanner;
    public final int maxSize;

    public OfVarIntSizePrefixed(int maxSize) {
        this.maxSize = maxSize;
        this.scanner = new Utils.VarIntByteScanner();
    }

    @Override
    @Nullable
    public ByteBuf tryDecode(ByteBufs bufs) throws MalformedDataException {
        int bytes = bufs.scanBytes((ByteBufs.ByteScanner)this.scanner);
        if (bytes == 0) {
            return null;
        }
        int size = this.scanner.getResult();
        if (size < 0) {
            throw new InvalidSizeException("Invalid size of bytes to be read, should be greater than 0");
        }
        if (size > this.maxSize) {
            throw new InvalidSizeException("Size exceeds max size");
        }
        if (!bufs.hasRemainingBytes(bytes + size)) {
            return null;
        }
        bufs.skip(bytes);
        return bufs.takeExactSize(size);
    }
}

