/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.binary.decoder.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.MalformedDataException;
import io.activej.csp.binary.decoder.ByteBufsDecoder;
import org.jetbrains.annotations.Nullable;

public class OfCrlfTerminated
implements ByteBufsDecoder<ByteBuf> {
    public final int maxSize;

    public OfCrlfTerminated(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    @Nullable
    public ByteBuf tryDecode(ByteBufs bufs) throws MalformedDataException {
        int bytes = bufs.scanBytes(new ByteBufs.ByteScanner(){
            boolean crFound;

            public boolean consume(int index, byte b) throws MalformedDataException {
                if (this.crFound) {
                    if (b == 10) {
                        return true;
                    }
                    this.crFound = false;
                }
                if (index == OfCrlfTerminated.this.maxSize - 1) {
                    throw new MalformedDataException("No CRLF is found in " + OfCrlfTerminated.this.maxSize + " bytes");
                }
                if (b == 13) {
                    this.crFound = true;
                }
                return false;
            }
        });
        if (bytes == 0) {
            return null;
        }
        ByteBuf buf = bufs.takeExactSize(bytes);
        buf.moveTail(-2);
        return buf;
    }
}

