/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.binary.codec.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.MalformedDataException;
import io.activej.csp.binary.codec.ByteBufsCodec;
import io.activej.serializer.BinaryInput;
import io.activej.serializer.stream.EOSException;
import io.activej.serializer.stream.StreamDecoder;
import io.activej.serializer.stream.StreamEncoder;
import io.activej.serializer.stream.StreamInput;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public final class OfStreamCodecs<I, O>
implements ByteBufsCodec<I, O> {
    public final StreamDecoder<I> input;
    public final StreamEncoder<O> output;

    public OfStreamCodecs(StreamDecoder<I> input, StreamEncoder<O> output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public ByteBuf encode(O item) {
        byte[] bytes = this.output.toByteArray(item);
        return ByteBuf.wrapForReading((byte[])bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public I tryDecode(ByteBufs bufs) throws MalformedDataException {
        ByteBuf buf = bufs.takeRemaining();
        BinaryInput binaryInput = new BinaryInput(buf.getArray());
        try {
            StreamInput streamInput = StreamInput.create((BinaryInput)binaryInput);
            try {
                Object decode;
                try {
                    decode = this.input.decode(streamInput);
                }
                catch (EOSException e) {
                    bufs.add(buf);
                    I i = null;
                    if (streamInput == null) return i;
                    streamInput.close();
                    return i;
                }
                buf.moveHead(binaryInput.pos());
                bufs.add(buf);
                Object object = decode;
                return (I)object;
            }
            finally {
                if (streamInput != null) {
                    try {
                        streamInput.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MalformedDataException((Throwable)e);
        }
    }
}

