/*
 * Decompiled with CFR 0.152.
 */
package io.activej.bytebuf.util;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.MemSize;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class ByteBufWriter
extends Writer {
    public static final MemSize INITIAL_BUF_SIZE = MemSize.kilobytes((long)2L);
    private final Charset charset;
    private ByteBuf byteBuf;
    private char[] surrogateBuffer;

    public ByteBufWriter() {
        this(INITIAL_BUF_SIZE, StandardCharsets.UTF_8);
    }

    public ByteBufWriter(MemSize initialSize) {
        this(initialSize, StandardCharsets.UTF_8);
    }

    public ByteBufWriter(Charset charset) {
        this(INITIAL_BUF_SIZE, charset);
    }

    public ByteBufWriter(MemSize initialSize, Charset charset) {
        this.byteBuf = ByteBufPool.allocate(initialSize);
        this.charset = charset;
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        ByteBuffer buffer = this.charset.encode(CharBuffer.wrap(cbuf, off, len));
        this.byteBuf = ByteBufPool.append(this.byteBuf, buffer.array(), buffer.position(), buffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) {
        Object object = this.lock;
        synchronized (object) {
            char ch;
            if (this.surrogateBuffer == null) {
                this.surrogateBuffer = new char[2];
            }
            if (Character.isLowSurrogate(ch = (char)c)) {
                this.surrogateBuffer[1] = ch;
                this.write(this.surrogateBuffer, 0, 2);
            } else {
                this.surrogateBuffer[0] = ch;
                if (!Character.isHighSurrogate(ch)) {
                    this.write(this.surrogateBuffer, 0, 1);
                }
            }
        }
    }

    @Override
    public void write(char[] cbuf) {
        try {
            super.write(cbuf);
        }
        catch (IOException ignored) {
            throw new AssertionError((Object)"unreachable");
        }
    }

    @Override
    public void write(String str) {
        try {
            super.write(str);
        }
        catch (IOException ignored) {
            throw new AssertionError((Object)"unreachable");
        }
    }

    @Override
    public void write(String str, int off, int len) {
        try {
            super.write(str, off, len);
        }
        catch (IOException ignored) {
            throw new AssertionError((Object)"unreachable");
        }
    }

    @Override
    public Writer append(CharSequence csq) {
        try {
            return super.append(csq);
        }
        catch (IOException ignored) {
            throw new AssertionError((Object)"unreachable");
        }
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) {
        try {
            return super.append(csq, start, end);
        }
        catch (IOException ignored) {
            throw new AssertionError((Object)"unreachable");
        }
    }

    @Override
    public Writer append(char c) {
        try {
            return super.append(c);
        }
        catch (IOException ignored) {
            throw new AssertionError((Object)"unreachable");
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public ByteBuf getBuf() {
        return this.byteBuf;
    }
}

