/*
 * Decompiled with CFR 0.152.
 */
package io.activej.bytebuf;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ThreadLocalCharArray;
import io.activej.common.Checks;
import io.activej.common.exception.MalformedDataException;
import java.nio.charset.StandardCharsets;

public final class ByteBufStrings {
    private static final boolean CHECKS = Checks.isEnabled(ByteBufStrings.class);
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte SP = 32;
    public static final byte HT = 9;
    private static final byte[] MIN_LONG_BYTES = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
    private static final byte[] MIN_INT_BYTES = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};

    public static int encodeAscii(byte[] array, int pos, String string) {
        for (int i = 0; i < string.length(); ++i) {
            array[pos++] = (byte)string.charAt(i);
        }
        return string.length();
    }

    public static byte[] encodeAscii(String string) {
        byte[] array = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            array[i] = (byte)string.charAt(i);
        }
        return array;
    }

    public static void putAscii(ByteBuf buf, String string) {
        ByteBufStrings.encodeAscii(buf.array(), buf.tail(), string);
        buf.moveTail(string.length());
    }

    public static ByteBuf wrapAscii(String string) {
        byte[] array = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            array[i] = (byte)string.charAt(i);
        }
        return ByteBuf.wrapForReading(array);
    }

    public static String decodeAscii(byte[] array, int pos, int len, char[] tmpBuffer) {
        if (CHECKS) {
            Checks.checkArgument((tmpBuffer.length >= len ? 1 : 0) != 0, (Object)"given char buffer is not big enough");
        }
        int charIndex = 0;
        int end = pos + len;
        while (pos < end) {
            int c = array[pos++] & 0xFF;
            tmpBuffer[charIndex++] = (char)c;
        }
        return new String(tmpBuffer, 0, charIndex);
    }

    public static String decodeAscii(byte[] array, int pos, int len) {
        return ByteBufStrings.decodeAscii(array, pos, len, ThreadLocalCharArray.ensure(len));
    }

    public static String asAscii(ByteBuf buf) {
        String str = ByteBufStrings.decodeAscii(buf.array(), buf.head(), buf.readRemaining(), ThreadLocalCharArray.ensure(buf.readRemaining()));
        buf.recycle();
        return str;
    }

    public static String decodeAscii(byte[] array) {
        return ByteBufStrings.decodeAscii(array, 0, array.length, ThreadLocalCharArray.ensure(array.length));
    }

    public static void toLowerCaseAscii(byte[] bytes, int pos, int len) {
        for (int i = pos; i < pos + len; ++i) {
            byte b = bytes[i];
            if (b < 65 || b > 90) continue;
            bytes[i] = (byte)(b + 32);
        }
    }

    public static void toLowerCaseAscii(byte[] bytes) {
        ByteBufStrings.toLowerCaseAscii(bytes, 0, bytes.length);
    }

    public static void toLowerCaseAscii(ByteBuf buf) {
        ByteBufStrings.toLowerCaseAscii(buf.array(), buf.head(), buf.readRemaining());
    }

    public static void toUpperCaseAscii(byte[] bytes, int pos, int len) {
        for (int i = pos; i < pos + len; ++i) {
            byte b = bytes[i];
            if (b < 97 || b > 122) continue;
            bytes[i] = (byte)(b + -32);
        }
    }

    public static void toUpperCaseAscii(byte[] bytes) {
        ByteBufStrings.toUpperCaseAscii(bytes, 0, bytes.length);
    }

    public static void toUpperCaseAscii(ByteBuf buf) {
        ByteBufStrings.toUpperCaseAscii(buf.array(), buf.head(), buf.readRemaining());
    }

    public static boolean equalsLowerCaseAscii(byte[] lowerCasePattern, byte[] array, int offset, int size) {
        if (lowerCasePattern.length != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            byte a;
            byte p = lowerCasePattern[i];
            if (CHECKS) {
                Checks.checkArgument((p < 65 || p > 90 ? 1 : 0) != 0);
            }
            if ((a = array[offset + i]) == p || a >= 65 && a <= 90 && p - a == 32) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsUpperCaseAscii(byte[] upperCasePattern, byte[] array, int offset, int size) {
        if (upperCasePattern.length != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            byte a;
            byte p = upperCasePattern[i];
            if (CHECKS) {
                Checks.checkArgument((p < 97 || p > 122 ? 1 : 0) != 0);
            }
            if ((a = array[offset + i]) >= 97 && a <= 122) {
                a = (byte)(a - 57);
            }
            if (a == p) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(byte[] array, int offset, int size) {
        int result = 1;
        for (int i = offset; i < offset + size; ++i) {
            result = 31 * result + array[i];
        }
        return result;
    }

    public static int hashCode(byte[] array) {
        return ByteBufStrings.hashCode(array, 0, array.length);
    }

    public static int hashCode(ByteBuf buf) {
        return ByteBufStrings.hashCode(buf.array(), buf.head(), buf.readRemaining());
    }

    public static int hashCodeLowerCaseAscii(byte[] array, int offset, int size) {
        int result = 1;
        for (int i = offset; i < offset + size; ++i) {
            byte a = array[i];
            if (a >= 65 && a <= 90) {
                a = (byte)(a + 32);
            }
            result = 31 * result + a;
        }
        return result;
    }

    public static int hashCodeLowerCaseAscii(byte[] array) {
        return ByteBufStrings.hashCodeLowerCaseAscii(array, 0, array.length);
    }

    public static int hashCodeLowerCaseAscii(ByteBuf buf) {
        return ByteBufStrings.hashCodeLowerCaseAscii(buf.array(), buf.head(), buf.readRemaining());
    }

    public static int hashCodeUpperCaseAscii(byte[] array, int offset, int size) {
        int result = 1;
        for (int i = offset; i < offset + size; ++i) {
            byte a = array[i];
            if (a >= 97 && a <= 122) {
                a = (byte)(a - 32);
            }
            result = 31 * result + a;
        }
        return result;
    }

    public static int hashCodeUpperCaseAscii(byte[] array) {
        return ByteBufStrings.hashCodeUpperCaseAscii(array, 0, array.length);
    }

    public static int hashCodeUpperCaseAscii(ByteBuf buf) {
        return ByteBufStrings.hashCodeUpperCaseAscii(buf.array(), buf.head(), buf.readRemaining());
    }

    public static int encodeUtf8(byte[] array, int offset, String string) {
        int pos = offset;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                array[pos++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                array[pos] = (byte)(0xC0 | c >>> 6);
                array[pos + 1] = (byte)(0x80 | c & 0x3F);
                pos += 2;
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                array[pos] = (byte)(0xE0 | c >>> 12);
                array[pos + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                array[pos + 2] = (byte)(0x80 | c & 0x3F);
                pos += 3;
                continue;
            }
            byte inc = ByteBufStrings.writeUtf8char4(array, pos, c, string, i);
            pos += inc;
            i += inc >>> 2;
        }
        return pos - offset;
    }

    private static byte writeUtf8char4(byte[] buf, int pos, char high, String s, int i) {
        int cp;
        char low;
        if (Character.isHighSurrogate(high) && i + 1 < s.length() && Character.isLowSurrogate(low = s.charAt(i + 1)) && (cp = Character.toCodePoint(high, low)) >= 65536 && cp <= 0x10FFFF) {
            buf[pos + 0] = (byte)(0xF0 | cp >>> 18);
            buf[pos + 1] = (byte)(0x80 | cp >>> 12 & 0x3F);
            buf[pos + 2] = (byte)(0x80 | cp >>> 6 & 0x3F);
            buf[pos + 3] = (byte)(0x80 | cp & 0x3F);
            return 4;
        }
        return 0;
    }

    public static void putUtf8(ByteBuf buf, String string) {
        int size = ByteBufStrings.encodeUtf8(buf.array(), buf.tail(), string);
        buf.moveTail(size);
    }

    public static ByteBuf wrapUtf8(String string) {
        int allocationSize = string.length() * 3;
        if (allocationSize == 0) {
            return ByteBuf.empty();
        }
        ByteBuf byteBuffer = ByteBufPool.allocate(allocationSize);
        int size = ByteBufStrings.encodeUtf8(byteBuffer.array(), 0, string);
        byteBuffer.moveTail(size);
        return byteBuffer;
    }

    public static String decodeUtf8(byte[] array, int pos, int len) throws MalformedDataException {
        try {
            return new String(array, pos, len, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new MalformedDataException((Throwable)e);
        }
    }

    public static String decodeUtf8(ByteBuf buf) throws MalformedDataException {
        return ByteBufStrings.decodeUtf8(buf.array(), buf.head(), buf.readRemaining());
    }

    public static String decodeUtf8(byte[] array) throws MalformedDataException {
        return ByteBufStrings.decodeUtf8(array, 0, array.length);
    }

    public static String asUtf8(ByteBuf buf) throws MalformedDataException {
        String str = ByteBufStrings.decodeUtf8(buf.array(), buf.head(), buf.readRemaining());
        buf.recycle();
        return str;
    }

    public static int encodeInt(byte[] array, int pos, int value) {
        if (value >= 0) {
            return ByteBufStrings.encodePositiveInt(array, pos, value);
        }
        return ByteBufStrings.encodeNegativeInt(array, pos, value);
    }

    public static int encodePositiveInt(byte[] array, int pos, int value) {
        if (value < 10) {
            array[pos] = (byte)(48 + value);
            return 1;
        }
        return ByteBufStrings.encodePositiveInt2(array, pos, value);
    }

    private static int encodePositiveInt2(byte[] array, int pos, int value) {
        if (value < 100) {
            array[pos] = (byte)(48 + value / 10);
            array[pos + 1] = (byte)(48 + value % 10);
            return 2;
        }
        return ByteBufStrings.encodePositiveInt3(array, pos, value);
    }

    private static int encodePositiveInt3(byte[] array, int pos, int value) {
        if (value < 1000) {
            array[pos] = (byte)(48 + value / 100);
            array[pos + 1] = (byte)(48 + value / 10 % 10);
            array[pos + 2] = (byte)(48 + value % 10);
            return 3;
        }
        return ByteBufStrings.encodePositiveIntN(array, pos, value);
    }

    private static int encodePositiveIntN(byte[] array, int pos, int value) {
        int digits = ByteBufStrings.digitsInt(value);
        for (int i = pos + digits - 1; i >= pos; --i) {
            long digit = value % 10;
            value /= 10;
            array[i] = (byte)(48L + digit);
        }
        return digits;
    }

    private static int encodeNegativeInt(byte[] array, int pos, int value) {
        if (value == Integer.MIN_VALUE) {
            System.arraycopy(MIN_INT_BYTES, 0, array, pos, 11);
            return 11;
        }
        value = -value;
        int digits = ByteBufStrings.digitsInt(value);
        for (int i = pos + digits; i >= pos + 1; --i) {
            int digit = value % 10;
            value /= 10;
            array[i] = (byte)(48 + digit);
        }
        array[i] = 45;
        return digits + 1;
    }

    public static int encodeLong(byte[] array, int pos, long value) {
        if (value >= 0L) {
            return ByteBufStrings.encodePositiveLong(array, pos, value);
        }
        return ByteBufStrings.encodeNegativeLong(array, pos, value);
    }

    public static int encodePositiveLong(byte[] array, int pos, long value) {
        int digits = ByteBufStrings.digitsLong(value);
        for (int i = pos + digits - 1; i >= pos; --i) {
            long digit = value % 10L;
            value /= 10L;
            array[i] = (byte)(48L + digit);
        }
        return digits;
    }

    private static int encodeNegativeLong(byte[] array, int pos, long value) {
        if (value == Long.MIN_VALUE) {
            System.arraycopy(MIN_LONG_BYTES, 0, array, pos, 20);
            return 20;
        }
        value = -value;
        int digits = ByteBufStrings.digitsLong(value);
        for (int i = pos + digits; i >= pos + 1; --i) {
            long digit = value % 10L;
            value /= 10L;
            array[i] = (byte)(48L + digit);
        }
        array[i] = 45;
        return digits + 1;
    }

    public static void putInt(ByteBuf buf, int value) {
        int digits = ByteBufStrings.encodeInt(buf.array(), buf.tail(), value);
        buf.moveTail(digits);
    }

    public static void putPositiveInt(ByteBuf buf, int value) {
        int digits = ByteBufStrings.encodePositiveInt(buf.array(), buf.tail(), value);
        buf.moveTail(digits);
    }

    public static void putLong(ByteBuf buf, long value) {
        int digits = ByteBufStrings.encodeLong(buf.array(), buf.tail(), value);
        buf.moveTail(digits);
    }

    public static void putPositiveLong(ByteBuf buf, long value) {
        int digits = ByteBufStrings.encodePositiveLong(buf.array(), buf.tail(), value);
        buf.moveTail(digits);
    }

    public static ByteBuf wrapInt(int value) {
        ByteBuf buf = ByteBufPool.allocate(11);
        int digits = ByteBufStrings.encodeInt(buf.array, 0, value);
        buf.moveTail(digits);
        return buf;
    }

    public static ByteBuf wrapLong(long value) {
        ByteBuf buf = ByteBufPool.allocate(20);
        int digits = ByteBufStrings.encodeLong(buf.array, 0, value);
        buf.moveTail(digits);
        return buf;
    }

    public static int decodeInt(byte[] array, int pos, int len) throws MalformedDataException {
        int result = 0;
        int i = pos;
        int negate = 0;
        if (array[i] == 45) {
            negate = 1;
            ++i;
        }
        while (i < pos + len) {
            byte b = (byte)(array[i] - 48);
            if (b < 0 || b >= 10) {
                throw new MalformedDataException("Not a decimal value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
            }
            if ((result = b + result * 10) < 0) {
                if (result == Integer.MIN_VALUE && i + 1 == pos + len) {
                    return Integer.MIN_VALUE;
                }
                throw new MalformedDataException("Bigger than max int value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
            }
            ++i;
        }
        return (result ^ -negate) + negate;
    }

    public static long decodeLong(byte[] array, int pos, int len) throws MalformedDataException {
        long result = 0L;
        int i = pos;
        int negate = 0;
        if (array[i] == 45) {
            negate = 1;
            ++i;
        }
        while (i < pos + len) {
            byte b = (byte)(array[i] - 48);
            if (b < 0 || b >= 10) {
                throw new MalformedDataException("Not a decimal value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
            }
            if ((result = (long)b + result * 10L) < 0L) {
                if (result == Long.MIN_VALUE && i + 1 == pos + len) {
                    return Long.MIN_VALUE;
                }
                throw new MalformedDataException("Bigger than max long value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
            }
            ++i;
        }
        return (result ^ (long)(-negate)) + (long)negate;
    }

    public static int decodePositiveInt(byte[] array, int pos, int len) throws MalformedDataException {
        int result = 0;
        for (int i = pos; i < pos + len; ++i) {
            byte b = (byte)(array[i] - 48);
            if (b < 0 || b >= 10) {
                throw new MalformedDataException("Not a decimal value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
            }
            if ((result = b + result * 10) >= 0) continue;
            throw new MalformedDataException("Bigger than max int value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
        }
        return result;
    }

    public static long decodePositiveLong(byte[] array, int pos, int len) throws MalformedDataException {
        long result = 0L;
        for (int i = pos; i < pos + len; ++i) {
            byte b = (byte)(array[i] - 48);
            if (b < 0 || b >= 10) {
                throw new MalformedDataException("Not a decimal value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
            }
            if ((result = (long)b + result * 10L) >= 0L) continue;
            throw new MalformedDataException("Bigger than max long value: " + new String(array, pos, len, StandardCharsets.ISO_8859_1));
        }
        return result;
    }

    private static int digitsLong(long value) {
        long limit = 10L;
        for (int i = 1; i <= 18; ++i) {
            if (value < limit) {
                return i;
            }
            limit *= 10L;
        }
        return 19;
    }

    private static int digitsInt(int value) {
        int limit = 10;
        for (int i = 1; i <= 9; ++i) {
            if (value < limit) {
                return i;
            }
            limit *= 10;
        }
        return 10;
    }
}

