/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.annotation.processing;

import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import picocli.CommandLine;
import picocli.codegen.annotation.processing.TypedMember;

class MixinInfo {
    private final String mixinName;
    private final CommandLine.Model.IAnnotatedElement annotatedElement;
    private final VariableElement element;
    private final CommandLine.Model.CommandSpec mixin;

    public MixinInfo(VariableElement element, CommandLine.Model.CommandSpec mixin) {
        this.element = element;
        this.mixin = mixin;
        String name = element.getAnnotation(CommandLine.Mixin.class).name();
        if (name.length() == 0) {
            name = element.getSimpleName().toString();
        }
        this.mixinName = name;
        Element targetType = element.getEnclosingElement();
        int position = -1;
        if (EnumSet.of(ElementKind.METHOD, ElementKind.CONSTRUCTOR).contains((Object)targetType.getKind())) {
            List<? extends VariableElement> parameters = ((ExecutableElement)targetType).getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                if (!parameters.get(i).getSimpleName().contentEquals(element.getSimpleName())) continue;
                position = i;
                break;
            }
        }
        this.annotatedElement = new TypedMember(element, position);
    }

    public Element enclosingElement() {
        return this.element.getEnclosingElement();
    }

    public String mixinName() {
        return this.mixinName;
    }

    public CommandLine.Model.CommandSpec mixin() {
        return this.mixin;
    }

    public CommandLine.Model.IAnnotatedElement annotatedElement() {
        return this.annotatedElement;
    }

    public int hashCode() {
        int result = 17;
        result += result * 37 + this.mixinName.hashCode();
        result += result * 37 + this.element.getSimpleName().hashCode();
        result += result * 37 + this.mixin.userObject().toString().hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MixinInfo)) {
            return false;
        }
        MixinInfo other = (MixinInfo)object;
        if (!this.mixinName.equals(other.mixinName)) {
            return false;
        }
        if (!this.element.getSimpleName().equals(other.element.getSimpleName())) {
            return false;
        }
        return this.mixin.userObject().toString().equals(other.mixin.userObject().toString());
    }
}

