/*
 * Decompiled with CFR 0.152.
 */
package cucumber.deps.com.thoughtworks.xstream.io.xml;

import cucumber.deps.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import cucumber.deps.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import cucumber.deps.com.thoughtworks.xstream.io.StreamException;
import cucumber.deps.com.thoughtworks.xstream.io.naming.NameCoder;
import cucumber.deps.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import cucumber.deps.com.thoughtworks.xstream.io.xml.DomReader;
import cucumber.deps.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import cucumber.deps.com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import cucumber.deps.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomDriver
extends AbstractXmlDriver {
    private final String encoding;
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public DomDriver() {
        this((String)null);
    }

    public DomDriver(String encoding) {
        this(encoding, new XmlFriendlyNameCoder());
    }

    public DomDriver(String encoding, NameCoder nameCoder) {
        super(nameCoder);
        this.encoding = encoding;
    }

    public DomDriver(String encoding, XmlFriendlyReplacer replacer) {
        this(encoding, (NameCoder)replacer);
    }

    public HierarchicalStreamReader createReader(Reader in) {
        return this.createReader(new InputSource(in));
    }

    public HierarchicalStreamReader createReader(InputStream in) {
        return this.createReader(new InputSource(in));
    }

    public HierarchicalStreamReader createReader(URL in) {
        return this.createReader(new InputSource(in.toExternalForm()));
    }

    public HierarchicalStreamReader createReader(File in) {
        return this.createReader(new InputSource(in.toURI().toASCIIString()));
    }

    private HierarchicalStreamReader createReader(InputSource source) {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            if (this.encoding != null) {
                source.setEncoding(this.encoding);
            }
            Document document = documentBuilder.parse(source);
            return new DomReader(document, this.getNameCoder());
        }
        catch (FactoryConfigurationError e) {
            throw new StreamException(e);
        }
        catch (ParserConfigurationException e) {
            throw new StreamException(e);
        }
        catch (SAXException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.getNameCoder());
    }

    public HierarchicalStreamWriter createWriter(OutputStream out) {
        try {
            return this.createWriter(this.encoding != null ? new OutputStreamWriter(out, this.encoding) : new OutputStreamWriter(out));
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamException(e);
        }
    }
}

