/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

public interface StopWatch {
    public static final StopWatch SYSTEM = new StopWatch(){
        private final ThreadLocal<Long> start = new ThreadLocal();

        @Override
        public void start() {
            this.start.set(System.nanoTime());
        }

        @Override
        public long stop() {
            Long duration = System.nanoTime() - this.start.get();
            this.start.set(null);
            return duration;
        }
    };

    public void start();

    public long stop();

    public static class Stub
    implements StopWatch {
        private final long duration;

        public Stub(long duration) {
            this.duration = duration;
        }

        @Override
        public void start() {
        }

        @Override
        public long stop() {
            return this.duration;
        }
    }
}

