/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.xsd;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import jlibs.core.io.CharArrayWriter2;
import jlibs.core.lang.ImpossibleException;
import jlibs.core.lang.OS;
import jlibs.core.net.URLUtil;
import jlibs.xml.sax.SAXDelegate;
import jlibs.xml.sax.SAXUtil;
import jlibs.xml.sax.helpers.MyNamespaceSupport;
import jlibs.xml.xsd.XSDocument;
import jlibs.xml.xsl.TransformerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class XSInliner
extends SAXDelegate {
    private static final String SCHEMA_LOCATION = "schemaLocation";
    private static final String IMPORT = "import";
    private String outputSystemID;
    private static final List<String> TOP_ELEMS = Arrays.asList("import", "redefine", "annotation");
    Context mainContext;
    Context curContext;
    private String tempSystemID;
    private static final List<String> QNAME_ATTS = Arrays.asList("type", "ref", "base");
    private Set<String> included = new HashSet<String>();

    public Document inline(InputSource input, String outputSystemID) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException {
        DOMResult result = new DOMResult();
        TransformerHandler handler = TransformerUtil.newTransformerHandler(null, (boolean)true, (int)4, null);
        this.setHandler(handler);
        handler.setResult(result);
        String string = this.outputSystemID = outputSystemID == null ? input.getSystemId() : outputSystemID;
        if (this.outputSystemID != null) {
            this.outputSystemID = URLUtil.toURL((String)this.outputSystemID).toString();
        }
        this.parse(input);
        Document doc = (Document)result.getNode();
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        ArrayList<Node> list = new ArrayList<Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"http://www.w3.org/2001/XMLSchema".equals(child.getNamespaceURI()) || !TOP_ELEMS.contains(child.getLocalName())) continue;
            list.add(child);
        }
        for (Node node : list) {
            node.getParentNode().removeChild(node);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Node node;
            node = (Node)list.get(i);
            if (root.getFirstChild() == null) {
                root.appendChild(node);
                continue;
            }
            root.insertBefore(node, root.getFirstChild());
        }
        return doc;
    }

    public Document inline(InputSource input) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException {
        return this.inline(input, null);
    }

    private void parse(InputSource source) throws ParserConfigurationException, IOException, SAXException {
        SAXParser parser = SAXUtil.newSAXParser((boolean)true, (boolean)false, (boolean)false);
        SAXUtil.setHandler((XMLReader)parser.getXMLReader(), (Object)((Object)this));
        parser.getXMLReader().parse(source);
    }

    public void setDocumentLocator(Locator locator) {
        this.tempSystemID = locator.getSystemId();
    }

    public void startDocument() throws SAXException {
        this.curContext = new Context(this.curContext, this.tempSystemID);
        if (this.mainContext == null) {
            this.mainContext = this.curContext;
        }
        this.curContext.nsSupport.startDocument();
        if (this.isMainDocument()) {
            super.startDocument();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.curContext.nsSupport.startPrefixMapping(prefix, uri);
        if (!this.isMainDocument()) {
            if (this.mainContext.nsSupport.findPrefix(uri) != null) {
                return;
            }
            prefix = this.mainContext.nsSupport.startPrefixMapping(uri);
            if (this.curContext.depth == 0) {
                return;
            }
        }
        super.startPrefixMapping(prefix, uri);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        AttributesImpl newAtts;
        String prefix;
        ++this.curContext.depth;
        this.curContext.nsSupport.startElement();
        Enumeration declaredPrefixes = this.mainContext.nsSupport.getDeclaredPrefixes();
        if (!this.isMainDocument()) {
            this.mainContext.nsSupport.startElement();
        }
        if (this.isInclude(uri, localName)) {
            try {
                InputSource importSource = null;
                String location = this.curContext.resolve(atts.getValue(SCHEMA_LOCATION));
                String importElem = "<" + qName + " schemaLocation=\"" + atts.getValue(SCHEMA_LOCATION) + "\">";
                this.comment(importElem.toCharArray(), 0, importElem.length());
                if (!this.included.add(location)) {
                    return;
                }
                EntityResolver resolver = this.getEntityResolver();
                if (resolver != null) {
                    importSource = resolver.resolveEntity(null, location);
                }
                if (importSource == null) {
                    importSource = new InputSource(location);
                }
                this.parse(importSource);
                return;
            }
            catch (Exception ex) {
                if (ex instanceof SAXException) {
                    throw (SAXException)ex;
                }
                throw new SAXException(ex);
            }
        }
        if (this.isRoot(uri, localName)) {
            this.curContext.setTargetNamespace(atts.getValue("targetNamespace"));
            if (this.isMainDocument() && !this.mainContext.targetNamespace.isEmpty() && this.mainContext.nsSupport.findPrefix(this.mainContext.targetNamespace) == null) {
                prefix = this.mainContext.nsSupport.declarePrefix(this.mainContext.targetNamespace);
                super.startPrefixMapping(prefix, this.mainContext.targetNamespace);
            }
        }
        if (this.isMainDocument()) {
            if (this.isImport(uri, localName) && atts.getValue(SCHEMA_LOCATION) != null) {
                newAtts = new AttributesImpl(atts);
                String attValue = atts.getValue(SCHEMA_LOCATION);
                String location = this.curContext.resolve(attValue);
                attValue = URLUtil.relativize((String)this.outputSystemID, (String)location).toString();
                newAtts.setValue(atts.getIndex(SCHEMA_LOCATION), attValue);
                atts = newAtts;
            }
        } else {
            if (this.isRoot(uri, localName)) {
                return;
            }
            qName = this.mainContext.nsSupport.toQName(uri, localName);
            newAtts = new AttributesImpl();
            for (int i = 0; i < atts.getLength(); ++i) {
                String attURI = atts.getURI(i);
                String attLocalName = atts.getLocalName(i);
                String attQName = attURI.isEmpty() ? attLocalName : this.mainContext.nsSupport.toQName(attURI, attLocalName);
                String attValue = atts.getValue(i);
                if (attURI.isEmpty()) {
                    if (uri.equals("http://www.w3.org/2001/XMLSchema") && QNAME_ATTS.contains(attLocalName)) {
                        QName qnameObj = this.curContext.nsSupport.toQName(attValue);
                        String qnameURI = qnameObj.getNamespaceURI();
                        if (qnameURI.isEmpty() && this.curContext.targetNamespace.isEmpty()) {
                            qnameURI = this.mainContext.targetNamespace;
                        }
                        attValue = this.mainContext.nsSupport.toQName(qnameURI, qnameObj.getLocalPart());
                    } else if (SCHEMA_LOCATION.equals(attLocalName) && this.isImport(uri, localName)) {
                        String location = this.curContext.resolve(attValue);
                        attValue = URLUtil.relativize((String)this.outputSystemID, (String)location).toString();
                    }
                }
                newAtts.addAttribute(attURI, attLocalName, attQName, atts.getType(i), attValue);
            }
            atts = newAtts;
        }
        if (!this.isMainDocument() && this.curContext.depth == 2) {
            while (declaredPrefixes.hasMoreElements()) {
                prefix = (String)declaredPrefixes.nextElement();
                String u = this.mainContext.nsSupport.findURI(prefix);
                super.startPrefixMapping(prefix, u);
            }
        }
        super.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.curContext.depth;
        this.curContext.nsSupport.endElement();
        if (!this.isMainDocument()) {
            this.mainContext.nsSupport.endElement();
        }
        if (this.isInclude(uri, localName)) {
            String importElem = "</" + qName + ">";
            this.comment(importElem.toCharArray(), 0, importElem.length());
            return;
        }
        if (!this.isMainDocument()) {
            if (this.isRoot(uri, localName)) {
                return;
            }
            qName = this.mainContext.nsSupport.toQName(uri, localName);
        }
        super.endElement(uri, localName, qName);
        if (!this.isMainDocument() && this.curContext.depth == 1) {
            Enumeration declaredPrefixes = this.mainContext.nsSupport.getDeclaredPrefixes();
            while (declaredPrefixes.hasMoreElements()) {
                String prefix = (String)declaredPrefixes.nextElement();
                super.endPrefixMapping(prefix);
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.isMainDocument()) {
            super.endPrefixMapping(prefix);
        }
    }

    public void endDocument() throws SAXException {
        if (this.isMainDocument()) {
            super.endDocument();
        }
        this.curContext = this.curContext.parent;
    }

    private boolean isMainDocument() {
        return this.curContext == this.mainContext;
    }

    private boolean isRoot(String uri, String localName) {
        return "http://www.w3.org/2001/XMLSchema".equals(uri) && "schema".equals(localName);
    }

    private boolean isInclude(String uri, String localName) {
        return "http://www.w3.org/2001/XMLSchema".equals(uri) && "include".equals(localName);
    }

    private boolean isImport(String uri, String localName) {
        return "http://www.w3.org/2001/XMLSchema".equals(uri) && IMPORT.equals(localName);
    }

    public static InputSource include(String targetNamespace, String ... systemIDs) throws TransformerConfigurationException {
        CharArrayWriter2 writer = new CharArrayWriter2();
        XSDocument doc = new XSDocument(new StreamResult((Writer)writer), true, 4, null);
        try {
            doc.startDocument();
            doc.startSchema(targetNamespace);
            for (String systemID : systemIDs) {
                doc.addInclude(URLUtil.toURL((String)systemID).toString());
            }
            doc.endSchema();
            doc.endDocument();
        }
        catch (SAXException ex) {
            throw new ImpossibleException((Throwable)ex);
        }
        return new InputSource(writer.toCharSequence().asReader());
    }

    public static void main(String[] args) throws Exception {
        InputSource source;
        if (args.length == 0) {
            System.err.println("Usage:");
            System.err.println("\txsd-inline." + (OS.get().isWindows() ? "bat" : "sh") + " <xsd-file>");
            System.err.println("\txsd-inline." + (OS.get().isWindows() ? "bat" : "sh") + " <target-namespace> <xsd-file> ...");
            System.exit(1);
        }
        if (args.length == 1) {
            source = new InputSource(args[0]);
        } else {
            String targetNamespace = args[0];
            String[] xsdFiles = Arrays.copyOfRange(args, 1, args.length);
            source = XSInliner.include(targetNamespace, xsdFiles);
        }
        Document doc = new XSInliner().inline(source, "temp.xsd");
        TransformerUtil.newTransformer(null, (boolean)true, (int)0, null).transform(new DOMSource(doc), new StreamResult(System.out));
        System.out.println();
    }

    static class Context {
        Context parent;
        MyNamespaceSupport nsSupport = new MyNamespaceSupport();
        String systemID;
        String targetNamespace;
        int depth;

        Context(Context parent, String systemID) {
            this.parent = parent;
            this.systemID = systemID;
        }

        String resolve(String location) {
            return URLUtil.resolve((String)this.systemID, (String)location).toString();
        }

        public void setTargetNamespace(String namespace) {
            this.targetNamespace = namespace == null ? "" : namespace;
        }
    }
}

