/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.xsd;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import jlibs.core.util.RandomUtil;
import jlibs.xml.sax.SAXUtil;
import jlibs.xml.xsd.XSInstance;
import jlibs.xml.xsd.XSUtil;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSampleValueGenerator
implements XSInstance.SampleValueGenerator {
    private Map<XSElementDeclaration, List<String>> elementValues = new HashMap<XSElementDeclaration, List<String>>();
    private Map<XSAttributeDeclaration, List<String>> attributeValues = new HashMap<XSAttributeDeclaration, List<String>>();

    public XMLSampleValueGenerator(final XSModel schema, InputSource sampleInput) throws SAXException, ParserConfigurationException, IOException {
        DefaultHandler handler = new DefaultHandler(){
            private List<QName> xpath = new ArrayList<QName>();
            private CharArrayWriter contents = new CharArrayWriter();

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.xpath.add(new QName(uri, localName));
                for (int i = 0; i < attributes.getLength(); ++i) {
                    QName qname = new QName(attributes.getURI(i), attributes.getLocalName(i));
                    this.xpath.add(qname);
                    XSAttributeDeclaration attr = XSUtil.findAttributeDeclaration(schema, this.xpath);
                    if (attr != null) {
                        ArrayList<String> values = (ArrayList<String>)XMLSampleValueGenerator.this.attributeValues.get(attr);
                        if (values == null) {
                            values = new ArrayList<String>();
                            XMLSampleValueGenerator.this.attributeValues.put(attr, values);
                        }
                        values.add(attributes.getValue(i));
                    }
                    this.xpath.remove(this.xpath.size() - 1);
                }
                this.contents.reset();
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                this.contents.write(ch, start, length);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                XSElementDeclaration elem;
                if (this.contents.size() > 0 && (elem = XSUtil.findElementDeclaration(schema, this.xpath)) != null) {
                    boolean simpleType = false;
                    if (elem.getTypeDefinition().getTypeCategory() == 16) {
                        simpleType = true;
                    } else {
                        XSComplexTypeDefinition complexType = (XSComplexTypeDefinition)elem.getTypeDefinition();
                        if (complexType.getContentType() == 1) {
                            simpleType = true;
                        }
                    }
                    if (simpleType) {
                        ArrayList<String> values = (ArrayList<String>)XMLSampleValueGenerator.this.elementValues.get(elem);
                        if (values == null) {
                            values = new ArrayList<String>();
                            XMLSampleValueGenerator.this.elementValues.put(elem, values);
                        }
                        values.add(this.contents.toString());
                    }
                }
                this.xpath.remove(this.xpath.size() - 1);
                this.contents.reset();
            }
        };
        SAXUtil.newSAXParser((boolean)true, (boolean)false, (boolean)false).parse(sampleInput, handler);
    }

    @Override
    public String generateSampleValue(XSElementDeclaration element, XSSimpleTypeDefinition simpleType) {
        List<String> values = this.elementValues.get(element);
        return values == null ? null : values.get(RandomUtil.random((int)0, (int)(values.size() - 1)));
    }

    @Override
    public String generateSampleValue(XSAttributeDeclaration attribute, XSSimpleTypeDefinition simpleType) {
        List<String> values = this.attributeValues.get(attribute);
        return values == null ? null : values.get(RandomUtil.random((int)0, (int)(values.size() - 1)));
    }
}

