/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.helpers;

import java.util.Enumeration;
import java.util.Properties;
import javax.xml.namespace.QName;
import jlibs.core.lang.Util;
import jlibs.xml.Namespaces;
import org.xml.sax.helpers.NamespaceSupport;

public class MyNamespaceSupport
extends NamespaceSupport {
    private Properties suggested;
    private String suggestPrefix = "ns";
    private boolean needNewContext;

    public MyNamespaceSupport() {
        this(Namespaces.getSuggested());
    }

    public MyNamespaceSupport(Properties suggested) {
        this.suggested = suggested;
    }

    public void suggestPrefix(String prefix, String uri) {
        this.suggested.put(uri, prefix);
    }

    public String findPrefix(String uri) {
        String prefix;
        if (uri == null) {
            uri = "";
        }
        if ((prefix = this.getPrefix(uri)) == null) {
            String defaultURI = this.getURI("");
            if (defaultURI == null) {
                defaultURI = "";
            }
            if (Util.equals((Object)uri, (Object)defaultURI)) {
                prefix = "";
            }
        }
        return prefix;
    }

    public String findURI(String prefix) {
        if (prefix == null) {
            return "";
        }
        String uri = this.getURI(prefix);
        if (uri == null && prefix.isEmpty()) {
            return "";
        }
        return uri;
    }

    public String getSuggestPrefix() {
        return this.suggestPrefix;
    }

    public void setSuggestPrefix(String suggestPrefix) {
        this.suggestPrefix = suggestPrefix;
    }

    public String declarePrefix(String uri) {
        String prefix = this.findPrefix(uri);
        if (prefix == null) {
            if (uri.isEmpty()) {
                prefix = "";
            } else {
                prefix = this.suggested.getProperty(uri, this.suggestPrefix);
                if (this.getURI(prefix) != null) {
                    if (prefix.isEmpty()) {
                        prefix = "ns";
                    }
                    int i = 1;
                    while (true) {
                        String _prefix;
                        if (this.getURI(_prefix = prefix + i) == null) {
                            prefix = _prefix;
                            break;
                        }
                        ++i;
                    }
                }
            }
            this.declarePrefix(prefix, uri);
        }
        return prefix;
    }

    @Override
    public Enumeration<String> getPrefixes(String uri) {
        return super.getPrefixes(uri);
    }

    @Override
    public Enumeration<String> getPrefixes() {
        return super.getPrefixes();
    }

    @Override
    public Enumeration<String> getDeclaredPrefixes() {
        return super.getDeclaredPrefixes();
    }

    public boolean isDeclaredPrefix(String prefix) {
        Enumeration<String> declaredPrefixes = this.getDeclaredPrefixes();
        while (declaredPrefixes.hasMoreElements()) {
            if (!prefix.equals(declaredPrefixes.nextElement())) continue;
            return true;
        }
        return false;
    }

    public QName toQName(String qname) {
        String uri;
        String prefix = "";
        String localName = qname;
        int colon = qname.indexOf(58);
        if (colon != -1) {
            prefix = qname.substring(0, colon);
            localName = qname.substring(colon + 1);
        }
        if ((uri = this.findURI(prefix)) == null) {
            throw new IllegalArgumentException("prefix \"" + prefix + "\" is not bound to any uri");
        }
        return new QName(uri, localName, prefix);
    }

    public String toQName(String uri, String localName) {
        String prefix = this.findPrefix(uri);
        if (prefix == null) {
            throw new IllegalArgumentException("no prefix found for uri \"" + uri + "\"");
        }
        return "".equals(prefix) ? localName : prefix + ':' + localName;
    }

    public void startDocument() {
        this.reset();
        this.needNewContext = true;
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (this.needNewContext) {
            this.pushContext();
            this.needNewContext = false;
        }
        this.declarePrefix(prefix, uri);
    }

    public String startPrefixMapping(String uri) {
        if (this.needNewContext) {
            this.pushContext();
            this.needNewContext = false;
        }
        return this.declarePrefix(uri);
    }

    public void startElement() {
        if (this.needNewContext) {
            this.pushContext();
        }
        this.needNewContext = true;
    }

    public void endElement() {
        this.popContext();
    }

    public static void main(String[] args) {
        MyNamespaceSupport ns = new MyNamespaceSupport();
        System.out.println(ns.declarePrefix("http://www.sonoasystems.com/schemas/2007/8/3/sci/"));
        System.out.println(ns.declarePrefix("http://www.sonoasystems.com/schemas/2007/8/7/sci/"));
        System.out.println(ns.declarePrefix("http://com"));
        System.out.println(ns.declarePrefix("http://google.org"));
    }
}

