/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax;

import java.util.HashSet;
import java.util.Set;
import jlibs.xml.sax.BaseXMLReader;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class AbstractXMLReader
extends BaseXMLReader {
    protected final Set<String> supportedFeatures = new HashSet<String>();
    private final Set<String> features = new HashSet<String>();
    protected boolean nsFeature;
    protected boolean nsPrefixesFeature;

    protected AbstractXMLReader() {
        this.supportedFeatures.add("http://xml.org/sax/features/namespaces");
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException {
        if (this.supportedFeatures.contains(name)) {
            if (value) {
                this.features.add(name);
            } else {
                this.features.remove(name);
            }
            if ("http://xml.org/sax/features/namespaces".equals(name)) {
                this.nsFeature = value;
            } else if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
                this.nsPrefixesFeature = value;
            }
        } else {
            throw new SAXNotRecognizedException(name);
        }
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException {
        if (this.supportedFeatures.contains(name)) {
            return this.features.contains(name);
        }
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!this._setProperty(name, value)) {
            throw new SAXNotRecognizedException(name);
        }
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException {
        Object value = this._getProperty(name);
        if (value != null) {
            return value;
        }
        throw new SAXNotRecognizedException(name);
    }
}

