/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.html.escape;

import gg.jte.TemplateOutput;

public class Escape {
    public static void htmlContent(String value, TemplateOutput output) {
        int lastIndex = 0;
        int length = value.length();
        block5: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "&amp;", output);
                    continue block5;
                }
                case '<': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "&lt;", output);
                    continue block5;
                }
                case '>': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "&gt;", output);
                }
            }
        }
        Escape.flushRemaining(value, output, lastIndex, length);
    }

    public static void htmlAttribute(String value, TemplateOutput output) {
        int lastIndex = 0;
        int length = value.length();
        block6: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\'': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "&#39;", output);
                    continue block6;
                }
                case '\"': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "&#34;", output);
                    continue block6;
                }
                case '&': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "&amp;", output);
                    continue block6;
                }
                case '<': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "&lt;", output);
                }
            }
        }
        Escape.flushRemaining(value, output, lastIndex, length);
    }

    public static void javaScriptBlock(String value, TemplateOutput output) {
        int lastIndex = 0;
        int length = value.length();
        block14: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\'': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\'", output);
                    continue block14;
                }
                case '\"': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\\"", output);
                    continue block14;
                }
                case '`': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\`", output);
                    continue block14;
                }
                case '$': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\$", output);
                    continue block14;
                }
                case '/': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\/", output);
                    continue block14;
                }
                case '-': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\-", output);
                    continue block14;
                }
                case '\\': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\\\", output);
                    continue block14;
                }
                case '\n': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\n", output);
                    continue block14;
                }
                case '\t': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\t", output);
                    continue block14;
                }
                case '\r': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\r", output);
                    continue block14;
                }
                case '\f': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\f", output);
                    continue block14;
                }
                case '\b': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\b", output);
                }
            }
        }
        Escape.flushRemaining(value, output, lastIndex, length);
    }

    public static void javaScriptAttribute(String value, TemplateOutput output) {
        int lastIndex = 0;
        int length = value.length();
        block12: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\'': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\x27", output);
                    continue block12;
                }
                case '\"': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\x22", output);
                    continue block12;
                }
                case '`': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\x60", output);
                    continue block12;
                }
                case '$': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\x24", output);
                    continue block12;
                }
                case '\\': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\\\", output);
                    continue block12;
                }
                case '\n': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\n", output);
                    continue block12;
                }
                case '\t': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\t", output);
                    continue block12;
                }
                case '\r': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\r", output);
                    continue block12;
                }
                case '\f': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\f", output);
                    continue block12;
                }
                case '\b': {
                    lastIndex = Escape.flushAndEscape(value, lastIndex, i, "\\b", output);
                }
            }
        }
        Escape.flushRemaining(value, output, lastIndex, length);
    }

    private static int flushAndEscape(String value, int lastIndex, int currentIndex, String escapeSequence, TemplateOutput output) {
        output.writeContent(value, lastIndex, currentIndex);
        output.writeContent(escapeSequence);
        return currentIndex + 1;
    }

    private static void flushRemaining(String value, TemplateOutput output, int lastIndex, int length) {
        if (lastIndex == 0) {
            output.writeContent(value);
        } else if (lastIndex < length) {
            output.writeContent(value, lastIndex, length);
        }
    }
}

